<?php
include 'includes/header.php';

// --- دریافت داده‌های داشبورد از دیتابیس ---

// 1. کارت‌های آمار کلی
$total_users = $pdo->query("SELECT COUNT(*) FROM users")->fetchColumn();
$active_resellers = $pdo->query("SELECT COUNT(*) FROM users WHERE role = 'reseller'")->fetchColumn();
$active_services = $pdo->query("SELECT COUNT(*) FROM orders WHERE status = 'active' AND expiry_date > NOW()")->fetchColumn();
$current_month_sales = $pdo->query("SELECT SUM(price) FROM orders WHERE MONTH(order_date) = MONTH(CURDATE()) AND YEAR(order_date) = YEAR(CURDATE())")->fetchColumn();
$most_popular_duration_query = $pdo->query("SELECT p.duration_days FROM orders o JOIN plans p ON o.plan_id = p.id GROUP BY p.duration_days ORDER BY COUNT(o.plan_id) DESC LIMIT 1");
$most_popular_duration = $most_popular_duration_query ? $most_popular_duration_query->fetchColumn() : 0;

// 2. آمار برای نمودار فروش روزانه (ماه جاری)
$daily_sales_data = $pdo->query("SELECT DAY(order_date) as day, SUM(price) as total_sales FROM orders WHERE MONTH(order_date) = MONTH(CURDATE()) AND YEAR(order_date) = YEAR(CURDATE()) GROUP BY DAY(order_date)")->fetchAll(PDO::FETCH_ASSOC);
$days_in_month = date('t');
$daily_sales_values = array_fill(1, $days_in_month, 0);
foreach ($daily_sales_data as $data) {
    $daily_sales_values[(int)$data['day']] = (int)$data['total_sales'];
}
$daily_sales_labels = range(1, $days_in_month);
$final_daily_sales_values = array_values($daily_sales_values);

// 3. آمار برای نمودار فروش ۱۲ ماه گذشته
$monthly_sales_data = $pdo->query("SELECT DATE_FORMAT(order_date, '%Y-%m') as month, SUM(price) as total_sales FROM orders WHERE order_date >= DATE_SUB(CURDATE(), INTERVAL 12 MONTH) GROUP BY month ORDER BY month")->fetchAll(PDO::FETCH_ASSOC);
$monthly_sales_map = [];
$monthly_labels = [];
for ($i = 11; $i >= 0; $i--) {
    $month_ts = strtotime("-$i months");
    $month_key = date('Y-m', $month_ts);
    $persian_months = [1=>'فروردین', 2=>'اردیبهشت', 3=>'خرداد', 4=>'تیر', 5=>'مرداد', 6=>'شهریور', 7=>'مهر', 8=>'آبان', 9=>'آذر', 10=>'دی', 11=>'بهمن', 12=>'اسفند'];
    $monthly_labels[] = $persian_months[date('n', $month_ts)];
    $monthly_sales_map[$month_key] = 0;
}
foreach ($monthly_sales_data as $data) {
    $year_month_key = date('Y-n', strtotime($data['order_date'] ?? 'now'));
     if (isset($monthly_sales_map[$year_month_key])) {
        $monthly_sales_map[$year_month_key] = (int)$data['total_sales'];
     }
}
$final_monthly_sales_values = array_values($monthly_sales_map);

// 4. آمار برای نمودار توزیع پلن‌ها
$plans_chart_data = $pdo->query("SELECT p.name, COUNT(o.plan_id) as order_count FROM orders o JOIN plans p ON o.plan_id = p.id GROUP BY o.plan_id ORDER BY order_count DESC")->fetchAll(PDO::FETCH_ASSOC);
$plans_chart_final_data = array_map(fn($item) => ['name' => $item['name'], 'value' => (int)$item['order_count']], $plans_chart_data);

// 5. آمار برای نمودار توزیع مدت زمان
$duration_chart_data = $pdo->query("SELECT p.duration_days, COUNT(o.plan_id) as order_count FROM orders o JOIN plans p ON o.plan_id = p.id GROUP BY p.duration_days ORDER BY order_count DESC")->fetchAll(PDO::FETCH_ASSOC);
$duration_chart_final_data = array_map(fn($item) => ['name' => $item['duration_days'] . ' روزه', 'value' => (int)$item['order_count']], $duration_chart_data);

// 6. دریافت آخرین سفارشات
$recent_orders = $pdo->query("SELECT o.*, u.username as platform_username, p.name as plan_name FROM orders o JOIN users u ON o.user_id = u.id JOIN plans p ON o.plan_id = p.id ORDER BY o.order_date DESC LIMIT 5")->fetchAll(PDO::FETCH_ASSOC);

// 7. دریافت آخرین کاربران ثبت‌نام شده
$recent_users = $pdo->query("SELECT username, role, created_at FROM users ORDER BY created_at DESC LIMIT 5")->fetchAll(PDO::FETCH_ASSOC);


include 'includes/sidebar.php'; 
?>

<main id="main-content" class="flex-1 p-6 mr-64 transition-all duration-300">
    <div class="mb-8">
        <h1 class="text-2xl font-bold text-gray-800">داشبورد مدیریت</h1>
        <p class="text-gray-600 mt-1">خوش آمدید! این یک نمای کلی از وضعیت کسب‌وکار شماست.</p>
    </div>
    
    <div class="grid grid-cols-1 md:grid-cols-3 lg:grid-cols-5 gap-6 mb-8">
        <div class="bg-white rounded-lg shadow-sm p-6 flex items-center justify-between">
            <div>
                <p class="text-gray-500 text-sm">کل کاربران</p>
                <h3 class="text-3xl font-bold text-gray-800 mt-1"><?= number_format($total_users) ?></h3>
            </div>
            <div class="w-12 h-12 rounded-full bg-blue-50 flex items-center justify-center text-primary"><i class="ri-user-3-line ri-xl"></i></div>
        </div>
        <div class="bg-white rounded-lg shadow-sm p-6 flex items-center justify-between">
            <div>
                <p class="text-gray-500 text-sm">فروش ماه جاری</p>
                <h3 class="text-3xl font-bold text-gray-800 mt-1"><?= number_format($current_month_sales ?? 0) ?></h3>
            </div>
            <div class="w-12 h-12 rounded-full bg-green-50 flex items-center justify-center text-green-500"><i class="ri-wallet-3-line ri-xl"></i></div>
        </div>
        <div class="bg-white rounded-lg shadow-sm p-6 flex items-center justify-between">
            <div>
                <p class="text-gray-500 text-sm">سرویس های فعال</p>
                <h3 class="text-3xl font-bold text-gray-800 mt-1"><?= number_format($active_services) ?></h3>
            </div>
            <div class="w-12 h-12 rounded-full bg-purple-50 flex items-center justify-center text-purple-500"><i class="ri-server-line ri-xl"></i></div>
        </div>
        <div class="bg-white rounded-lg shadow-sm p-6 flex items-center justify-between">
            <div>
                <p class="text-gray-500 text-sm">پلن محبوب</p>
                <h3 class="text-3xl font-bold text-gray-800 mt-1"><?= number_format($most_popular_duration) ?> <span class="text-lg font-normal">روزه</span></h3>
            </div>
            <div class="w-12 h-12 rounded-full bg-teal-50 flex items-center justify-center text-teal-500"><i class="ri-time-line ri-xl"></i></div>
        </div>
        <div class="bg-white rounded-lg shadow-sm p-6 flex items-center justify-between">
            <div>
                <p class="text-gray-500 text-sm">نمایندگان فعال</p>
                <h3 class="text-3xl font-bold text-gray-800 mt-1"><?= number_format($active_resellers) ?></h3>
            </div>
            <div class="w-12 h-12 rounded-full bg-orange-50 flex items-center justify-center text-orange-500"><i class="ri-team-line ri-xl"></i></div>
        </div>
    </div>

    <div class="grid grid-cols-1 lg:grid-cols-2 gap-6 mb-8">
        <div class="bg-white rounded-lg shadow-sm p-6">
            <h3 class="font-semibold text-gray-800 mb-6">آمار فروش روزانه (ماه جاری)</h3>
            <div id="daily-sales-chart" class="w-full h-[300px]"></div>
        </div>
        <div class="bg-white rounded-lg shadow-sm p-6">
            <h3 class="font-semibold text-gray-800 mb-6">آمار فروش ۱۲ ماه گذشته</h3>
            <div id="monthly-sales-chart" class="w-full h-[300px]"></div>
        </div>
        <div class="bg-white rounded-lg shadow-sm p-6">
            <h3 class="font-semibold text-gray-800 mb-6">توزیع مدت زمان فروش</h3>
            <div id="duration-chart" class="w-full h-[300px]"></div>
        </div>
        <div class="bg-white rounded-lg shadow-sm p-6">
            <h3 class="font-semibold text-gray-800 mb-6">توزیع پلن های پرفروش</h3>
            <div id="plans-chart" class="w-full h-[300px]"></div>
        </div>
    </div>

    <div class="bg-white rounded-lg shadow-sm p-6 mb-8">
        <div class="flex justify-between items-center mb-4">
            <h3 class="font-semibold text-gray-800">۵ سفارش اخیر</h3>
            <a href="orders.php" class="text-primary hover:text-primary-dark text-sm">مشاهده همه</a>
        </div>
        <div class="overflow-x-auto">
            <table class="w-full">
                <thead>
                    <tr class="border-b border-gray-200">
                        <th class="text-right py-3 px-4 text-sm font-medium text-gray-500">کاربر</th>
                        <th class="text-right py-3 px-4 text-sm font-medium text-gray-500">پلن</th>
                        <th class="text-right py-3 px-4 text-sm font-medium text-gray-500">مبلغ</th>
                        <th class="text-right py-3 px-4 text-sm font-medium text-gray-500">تاریخ</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if(empty($recent_orders)): ?>
                        <tr><td colspan="4" class="text-center py-4 text-gray-500">هیچ سفارشی یافت نشد.</td></tr>
                    <?php else: ?>
                        <?php foreach($recent_orders as $order): ?>
                        <tr class="border-b border-gray-100 hover:bg-gray-50">
                            <td class="py-3 px-4 text-sm text-gray-800"><?= htmlspecialchars($order['platform_username']) ?></td>
                            <td class="py-3 px-4 text-sm text-gray-800"><?= htmlspecialchars($order['plan_name']) ?></td>
                            <td class="py-3 px-4 text-sm text-gray-800"><?= number_format($order['price']) ?> تومان</td>
                            <td class="py-3 px-4 text-sm text-gray-500"><?= date("Y/m/d", strtotime($order['order_date'])) ?></td>
                        </tr>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>

    <div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
        <div class="bg-white rounded-lg shadow-sm p-6">
            <div class="flex justify-between items-center mb-4">
                <h3 class="font-semibold text-gray-800">کاربران جدید</h3>
                <a href="users.php" class="text-primary hover:text-primary-dark text-sm">مشاهده همه</a>
            </div>
            <div class="space-y-4">
                <?php if(empty($recent_users)): ?>
                    <p class="text-center text-gray-500 py-4">کاربر جدیدی یافت نشد.</p>
                <?php else: ?>
                    <?php 
                        $role_map = ['admin' => 'مدیر', 'reseller' => 'نماینده', 'user' => 'کاربر عادی'];
                        $role_color_map = ['admin' => 'bg-red-100 text-red-800', 'reseller' => 'bg-orange-100 text-orange-800', 'user' => 'bg-blue-100 text-blue-800'];
                    ?>
                    <?php foreach($recent_users as $user): ?>
                        <div class="flex items-center justify-between">
                            <div class="flex items-center">
                                <div class="w-10 h-10 bg-gray-100 rounded-full flex items-center justify-center text-gray-500">
                                    <i class="ri-user-line ri-lg"></i>
                                </div>
                                <div class="mr-3">
                                    <h4 class="text-sm font-medium text-gray-800"><?= htmlspecialchars($user['username']) ?></h4>
                                    <p class="text-xs text-gray-500">عضویت: <?= date("Y/m/d", strtotime($user['created_at'])) ?></p>
                                </div>
                            </div>
                            <span class="px-2 py-1 text-xs rounded-full <?= $role_color_map[$user['role']] ?? '' ?>">
                                <?= $role_map[$user['role']] ?? 'ناشناخته' ?>
                            </span>
                        </div>
                    <?php endforeach; ?>
                <?php endif; ?>
            </div>
        </div>

        <div class="bg-white rounded-lg shadow-sm p-6">
            <div class="flex justify-between items-center mb-4">
                <h3 class="font-semibold text-gray-800">فعالیت های اخیر</h3>
                <a href="#" class="text-primary hover:text-primary-dark text-sm">مشاهده همه</a>
            </div>
            <div class="text-center text-gray-400 py-10">
                <i class="ri-history-line text-4xl"></i>
                <p class="mt-2 text-sm">بخش فعالیت‌های اخیر در آینده پیاده‌سازی خواهد شد.</p>
            </div>
        </div>
    </div>
</main>

<script src="https://cdnjs.cloudflare.com/ajax/libs/echarts/5.5.0/echarts.min.js"></script>
<script>
document.addEventListener('DOMContentLoaded', function() {
    const lineChartOptions = {
        tooltip: { trigger: 'axis' },
        grid: { left: '10%', right: '4%', bottom: '15%', containLabel: true },
        xAxis: { type: 'category', boundaryGap: false },
        yAxis: { type: 'value', axisLabel: { formatter: '{value}' } },
        series: [{ type: 'line', smooth: true, areaStyle: {
            color: {
                type: 'linear', x: 0, y: 0, x2: 0, y2: 1,
                colorStops: [{ offset: 0, color: 'rgba(59, 130, 246, 0.3)'}, { offset: 1, color: 'rgba(59, 130, 246, 0)'}]
            }
        }, itemStyle: { color: '#3b82f6' } }]
    };

    const pieChartOptions = {
        tooltip: { trigger: 'item' },
        legend: { orient: 'vertical', left: 'left', top: 'center', textStyle: { fontFamily: 'Vazirmatn' } },
        series: [{ 
            type: 'pie', 
            radius: ['50%', '80%'], 
            center: ['70%', '50%'],
            avoidLabelOverlap: false, 
            itemStyle: { borderRadius: 8, borderColor: '#fff', borderWidth: 2 }, 
            label: { show: false }, 
            emphasis: { label: { show: false } }
        }]
    };

    // Daily Sales Chart
    const dailySalesChart = echarts.init(document.getElementById('daily-sales-chart'));
    dailySalesChart.setOption({ ...lineChartOptions, xAxis: { ...lineChartOptions.xAxis, data: <?= json_encode($daily_sales_labels) ?> }, series: [{ ...lineChartOptions.series[0], name: 'فروش روزانه', data: <?= json_encode($final_daily_sales_values) ?> }] });

    // Monthly Sales Chart
    const monthlySalesChart = echarts.init(document.getElementById('monthly-sales-chart'));
    monthlySalesChart.setOption({ ...lineChartOptions, xAxis: { ...lineChartOptions.xAxis, data: <?= json_encode($monthly_labels) ?> }, series: [{ ...lineChartOptions.series[0], name: 'فروش ماهانه', data: <?= json_encode($final_monthly_sales_values) ?> }] });

    // Duration Chart
    const durationChart = echarts.init(document.getElementById('duration-chart'));
    durationChart.setOption({ ...pieChartOptions, legend: {show: true}, series: [{ ...pieChartOptions.series[0], name: 'تعداد فروش', data: <?= json_encode($duration_chart_final_data) ?> }] });

    // Plans Chart
    const plansChart = echarts.init(document.getElementById('plans-chart'));
    plansChart.setOption({ ...pieChartOptions, legend: {show: true}, series: [{ ...pieChartOptions.series[0], name: 'تعداد فروش', data: <?= json_encode($plans_chart_final_data) ?> }] });

    window.addEventListener('resize', function() {
        dailySalesChart.resize();
        monthlySalesChart.resize();
        durationChart.resize();
        plansChart.resize();
    });
});
</script>

<?php include 'includes/footer.php'; ?>