<?php
function isPageActive($pageName) {
    $current_page = basename($_SERVER['PHP_SELF']);
    // اگر ورودی یک آرایه از صفحات بود (برای منوهای والد)
    if (is_array($pageName)) {
        return in_array($current_page, $pageName) ? 'active' : '';
    }
    // برای لینک‌های تکی
    return ($current_page == $pageName) ? 'active' : '';
}

// خواندن تنظیمات برای نمایش شرطی منوها
$is_reseller_system_enabled = (bool)setting('reseller_system_enabled', 0);
$is_affiliate_system_enabled = (bool)setting('affiliate_system_enabled', 0);
?>
<aside id="sidebar" class="bg-white w-64 shadow-sm fixed h-[calc(100vh-60px)] overflow-y-auto transition-all duration-300 z-10">
    <nav class="py-4">
        <ul>
            <li>
                <a href="dashboard.php" class="sidebar-item <?= isPageActive('dashboard.php'); ?> flex items-center px-4 py-3 text-gray-700 hover:text-primary">
                    <div class="w-8 flex items-center justify-center ml-3"><i class="ri-dashboard-line ri-lg"></i></div>
                    <span>داشبورد</span>
                </a>
            </li>
            <li>
                <a href="users.php" class="sidebar-item <?= isPageActive('users.php'); ?> flex items-center px-4 py-3 text-gray-700 hover:text-primary">
                    <div class="w-8 flex items-center justify-center ml-3"><i class="ri-user-settings-line ri-lg"></i></div>
                    <span>کاربران</span>
                </a>
            </li>
            <li>
                <a href="plans.php" class="sidebar-item <?= isPageActive('plans.php'); ?> flex items-center px-4 py-3 text-gray-700 hover:text-primary">
                    <div class="w-8 flex items-center justify-center ml-3"><i class="ri-price-tag-3-line ri-lg"></i></div>
                    <span>پلن ها</span>
                </a>
            </li>
            <li>
                <a href="orders.php" class="sidebar-item <?= isPageActive('orders.php'); ?> flex items-center px-4 py-3 text-gray-700 hover:text-primary">
                    <div class="w-8 flex items-center justify-center ml-3"><i class="ri-shopping-cart-line ri-lg"></i></div>
                    <span>سفارش ها</span>
                </a>
            </li>
            <li>
                <a href="tickets.php" class="sidebar-item <?= isPageActive(['tickets.php', 'view_ticket.php']); ?> flex items-center px-4 py-3 text-gray-700 hover:text-primary">
                    <div class="w-8 flex items-center justify-center ml-3"><i class="ri-customer-service-2-line ri-lg"></i></div>
                    <span>پشتیبانی</span>
                </a>
            </li>
            <li>
                <button class="sidebar-item submenu-toggle w-full flex items-center justify-between px-4 py-3 text-gray-700 hover:text-primary <?= isPageActive(['report-sales.php', 'report-resellers.php']); ?>">
                    <div class="flex items-center"><div class="w-8 ml-3 flex-c-c"><i class="ri-bar-chart-2-line ri-lg"></i></div><span>گزارش‌گیری</span></div>
                    <i class="ri-arrow-down-s-line transition-transform duration-200"></i>
                </button>
                <ul class="submenu bg-gray-50 pr-8">
                    <li><a href="report-sales.php" class="block py-2 px-4 text-sm">گزارش فروش</a></li>
                    <li><a href="report-resellers.php" class="block py-2 px-4 text-sm">عملکرد نمایندگان</a></li>
                </ul>
            </li>
            <li>
                <a href="send-notification.php" class="sidebar-item <?= isPageActive('send-notification.php'); ?> flex items-center px-4 py-3 text-gray-700 hover:text-primary">
                    <div class="w-8 flex items-center justify-center ml-3"><i class="ri-send-plane-2-line ri-lg"></i></div>
                    <span>ارسال اعلان</span>
                </a>
            </li>
            <li>
                <button class="sidebar-item submenu-toggle w-full flex items-center justify-between px-4 py-3 text-gray-700 hover:text-primary <?= isPageActive(['settings-general.php', 'settings-server.php', 'settings-payment.php', 'settings-reseller.php', 'settings-affiliate.php', 'settings-addons.php']); ?>">
                    <div class="flex items-center">
                        <div class="w-8 flex items-center justify-center ml-3"><i class="ri-settings-3-line ri-lg"></i></div>
                        <span>تنظیمات</span>
                    </div>
                    <i class="ri-arrow-down-s-line transition-transform duration-200"></i>
                </button>
                <ul class="submenu bg-gray-50 pr-8">
                    <li><a href="settings-general.php" class="block py-2 px-4 text-sm text-gray-700 hover:text-primary">عمومی</a></li>
                    <li><a href="settings-server.php" class="block py-2 px-4 text-sm text-gray-700 hover:text-primary">سرور</a></li>
                    <li><a href="settings-bot.php" class="block py-2 px-4 text-sm text-gray-700 hover:text-primary">ربات تلگرام</a></li>
                    <li><a href="settings-payment.php" class="block py-2 px-4 text-sm text-gray-700 hover:text-primary">پرداخت</a></li>
                    <?php if ($is_reseller_system_enabled): ?>
                        <li><a href="settings-reseller.php" class="block py-2 px-4 text-sm text-gray-700 hover:text-primary">نمایندگی</a></li>
                    <?php endif; ?>
                    <?php if ($is_affiliate_system_enabled): ?>
                        <li><a href="settings-affiliate.php" class="block py-2 px-4 text-sm text-gray-700 hover:text-primary">همکاری در فروش</a></li>
                    <?php endif; ?>
                     <li><a href="settings-addons.php" class="block py-2 px-4 text-sm text-gray-700 hover:text-primary">تنظیمات افزودنی‌ها</a></li>
                </ul>
            </li>
        </ul>
    </nav>
</aside>