<?php
require_once '../core/config.php';
require_once '../core/database.php';

$message = '';
$message_type = '';
$edit_plan = null;

if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['save_plan'])) {
    $plan_id = $_POST['plan_id'] ?? null;
    $name = trim($_POST['name']);
    $duration = (int)$_POST['duration'];
    $price = (int)$_POST['price'];
    $user_limit = (int)$_POST['user_limit'];
    $traffic_gb = (int)$_POST['traffic_gb'];
    $is_active = isset($_POST['is_active']) ? 1 : 0;
    $on_hold_enabled = isset($_POST['on_hold_enabled']) ? 1 : 0;

    if (empty($name) || empty($duration) || empty($price)) {
        $message = 'نام، مدت و قیمت پلن الزامی هستند.';
        $message_type = 'error';
    } else {
        try {
            if ($plan_id) {
                $stmt = $pdo->prepare("UPDATE plans SET name=?, duration_days=?, price=?, user_limit=?, traffic_gb=?, is_active=?, on_hold_enabled=? WHERE id=?");
                $stmt->execute([$name, $duration, $price, $user_limit, $traffic_gb, $is_active, $on_hold_enabled, $plan_id]);
                $message = 'پلن با موفقیت ویرایش شد.';
            } else {
                $stmt = $pdo->prepare("INSERT INTO plans (name, duration_days, price, user_limit, traffic_gb, is_active, on_hold_enabled) VALUES (?, ?, ?, ?, ?, ?, ?)");
                $stmt->execute([$name, $duration, $price, $user_limit, $traffic_gb, $is_active, $on_hold_enabled]);
                $message = 'پلن جدید با موفقیت اضافه شد.';
            }
            $message_type = 'success';
        } catch (PDOException $e) {
            $message = 'خطا در ذخیره سازی پلن: ' . $e->getMessage();
            $message_type = 'error';
        }
    }
}

if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['delete_plan'])) {
    $plan_id = $_POST['plan_id'];
    try {
        $stmt = $pdo->prepare("DELETE FROM plans WHERE id = ?");
        $stmt->execute([$plan_id]);
        $message = 'پلن با موفقیت حذف شد.';
        $message_type = 'success';
    } catch (PDOException $e) {
        $message = 'خطا در حذف پلن: ' . $e->getMessage();
        $message_type = 'error';
    }
}

if (isset($_GET['edit'])) {
    $edit_id = $_GET['edit'];
    $stmt = $pdo->prepare("SELECT * FROM plans WHERE id = ?");
    $stmt->execute([$edit_id]);
    $edit_plan = $stmt->fetch(PDO::FETCH_ASSOC);
}

$duration_filter = $_GET['duration'] ?? 'all';
$allowed_durations = [30, 60, 180, 365];

$sql = "SELECT p.*, COUNT(o.id) as sales_count 
        FROM plans p
        LEFT JOIN orders o ON p.id = o.plan_id";
$where_conditions = [];
$params = [];
if (in_array($duration_filter, $allowed_durations)) {
    $where_conditions[] = "p.duration_days = ?";
    $params[] = $duration_filter;
}
if (!empty($where_conditions)) {
    $sql .= " WHERE " . implode(' AND ', $where_conditions);
}
$sql .= " GROUP BY p.id ORDER BY p.price ASC";
$plans_stmt = $pdo->prepare($sql);
$plans_stmt->execute($params);
$plans = $plans_stmt->fetchAll(PDO::FETCH_ASSOC);

$duration_map = [
    30 => ['text' => '۱ ماهه', 'class' => 'bg-sky-100 text-sky-800'],
    60 => ['text' => '۲ ماهه', 'class' => 'bg-blue-100 text-blue-800'],
    180 => ['text' => '۶ ماهه', 'class' => 'bg-amber-100 text-amber-800'],
    365 => ['text' => '۱ ساله', 'class' => 'bg-purple-100 text-purple-800'],
];

include 'includes/header.php';
include 'includes/sidebar.php';
?>
<style>.switch{position:relative;display:inline-block;width:44px;height:24px}.switch input{opacity:0;width:0;height:0}.slider{position:absolute;cursor:pointer;top:0;left:0;right:0;bottom:0;background-color:#ccc;transition:.4s;border-radius:24px}.slider:before{position:absolute;content:"";height:18px;width:18px;left:3px;bottom:3px;background-color:white;transition:.4s;border-radius:50%}input:checked+.slider{background-color:#3b82f6}input:checked+.slider:before{transform:translateX(20px)}</style>
<main id="main-content" class="flex-1 p-6 mr-64 transition-all duration-300">
    <div class="flex justify-between items-center mb-6">
        <h1 class="text-2xl font-bold text-gray-800">مدیریت پلن ها</h1>
        <button id="add-plan-btn" class="bg-primary text-white px-5 py-2 rounded-lg hover:bg-primary/90 transition-colors flex items-center space-x-2 space-x-reverse"><i class="ri-add-line"></i><span>افزودن پلن جدید</span></button>
    </div>
    <div class="mb-6">
        <div class="flex border-b border-gray-200">
            <a href="plans.php?duration=all" class="px-4 py-2 text-sm font-medium <?= $duration_filter === 'all' ? 'border-b-2 border-primary text-primary' : 'text-gray-500 hover:text-gray-700' ?>">همه پلن ها</a>
            <a href="plans.php?duration=30" class="px-4 py-2 text-sm font-medium <?= $duration_filter == 30 ? 'border-b-2 border-primary text-primary' : 'text-gray-500 hover:text-gray-700' ?>">۱ ماهه</a>
            <a href="plans.php?duration=60" class="px-4 py-2 text-sm font-medium <?= $duration_filter == 60 ? 'border-b-2 border-primary text-primary' : 'text-gray-500 hover:text-gray-700' ?>">۲ ماهه</a>
            <a href="plans.php?duration=180" class="px-4 py-2 text-sm font-medium <?= $duration_filter == 180 ? 'border-b-2 border-primary text-primary' : 'text-gray-500 hover:text-gray-700' ?>">۶ ماهه</a>
            <a href="plans.php?duration=365" class="px-4 py-2 text-sm font-medium <?= $duration_filter == 365 ? 'border-b-2 border-primary text-primary' : 'text-gray-500 hover:text-gray-700' ?>">۱ ساله</a>
        </div>
    </div>
    <?php if ($message): ?>
        <div class="mb-4 p-4 rounded-lg <?= $message_type === 'success' ? 'bg-green-100 text-green-800' : 'bg-red-100 text-red-800' ?>"><?= htmlspecialchars($message) ?></div>
    <?php endif; ?>
    <div class="bg-white rounded-lg shadow-sm p-6">
        <div class="overflow-x-auto">
            <table class="w-full">
                <thead>
                    <tr class="border-b-2 border-gray-200">
                        <th class="text-right py-3 px-4 text-sm font-medium text-gray-500">نام پلن</th>
                        <th class="text-right py-3 px-4 text-sm font-medium text-gray-500">مدت زمان</th>
                        <th class="text-right py-3 px-4 text-sm font-medium text-gray-500">قیمت</th>
                        <th class="text-right py-3 px-4 text-sm font-medium text-gray-500">تعداد فروش</th>
                        <th class="text-right py-3 px-4 text-sm font-medium text-gray-500">وضعیت</th>
                        <th class="text-center py-3 px-4 text-sm font-medium text-gray-500">عملیات</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (empty($plans)): ?>
                        <tr><td colspan="6" class="text-center py-6 text-gray-500">هیچ پلنی یافت نشد.</td></tr>
                    <?php else: ?>
                        <?php foreach ($plans as $plan): ?>
                            <tr class="border-b border-gray-100 hover:bg-gray-50">
                                <td class="py-3 px-4 text-sm text-gray-800 font-semibold"><?= htmlspecialchars($plan['name']) ?></td>
                                <td class="py-3 px-4 text-sm"><span class="px-2 py-1 text-xs rounded-full <?= $duration_map[$plan['duration_days']]['class'] ?? 'bg-gray-100 text-gray-800' ?>"><?= htmlspecialchars($duration_map[$plan['duration_days']]['text'] ?? $plan['duration_days'] . ' روز') ?></span></td>
                                <td class="py-3 px-4 text-sm text-gray-800 font-mono"><?= number_format($plan['price']) ?> تومان</td>
                                <td class="py-3 px-4 text-sm text-gray-800 font-bold"><?= number_format($plan['sales_count']) ?></td>
                                <td class="py-3 px-4 text-sm"><?php if ($plan['is_active']): ?><span class="px-2 py-1 text-xs rounded-full bg-green-100 text-green-800">فعال</span><?php else: ?><span class="px-2 py-1 text-xs rounded-full bg-gray-100 text-gray-800">غیرفعال</span><?php endif; ?></td>
                                <td class="py-3 px-4 text-center">
                                    <div class="flex items-center justify-center gap-x-1">
                                        <a href="plans.php?edit=<?= $plan['id'] ?>&duration=<?= $duration_filter ?>" class="w-8 h-8 flex items-center justify-center text-blue-500 hover:bg-blue-50 rounded-lg"><i class="ri-pencil-line"></i></a>
                                        <form action="plans.php?duration=<?= $duration_filter ?>" method="POST" onsubmit="return confirm('آیا از حذف این پلن مطمئن هستید؟');"><input type="hidden" name="plan_id" value="<?= $plan['id'] ?>"><button type="submit" name="delete_plan" class="w-8 h-8 flex items-center justify-center text-red-500 hover:bg-red-50 rounded-lg"><i class="ri-delete-bin-line"></i></button></form>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</main>
<div id="plan-modal" class="hidden fixed inset-0 bg-black bg-opacity-50 flex items-center justify-center z-50 p-4">
    <div class="bg-white rounded-lg shadow-xl p-6 w-full max-w-2xl mx-4">
        <div class="flex justify-between items-center border-b pb-3 mb-4">
            <h2 id="modal-title" class="text-xl font-semibold text-gray-800"></h2>
            <button id="close-modal-btn" class="text-gray-500 hover:text-gray-800"><i class="ri-close-line ri-lg"></i></button>
        </div>
        <form id="plan-form" action="plans.php?duration=<?= htmlspecialchars($duration_filter) ?>" method="POST">
            <input type="hidden" name="plan_id" id="plan_id" value="<?= htmlspecialchars($edit_plan['id'] ?? '') ?>">
            <div class="space-y-4">
                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                    <div><label for="name" class="block text-sm font-medium text-gray-700 mb-1">نام پلن</label><input type="text" id="name" name="name" value="<?= htmlspecialchars($edit_plan['name'] ?? '') ?>" class="w-full bg-white rounded-lg border border-gray-300 focus:border-primary focus:ring-1 focus:ring-primary/50 transition" required></div>
                    <div><label for="price" class="block text-sm font-medium text-gray-700 mb-1">قیمت (تومان)</label><input type="number" id="price" name="price" value="<?= htmlspecialchars($edit_plan['price'] ?? '') ?>" class="w-full bg-white rounded-lg border border-gray-300 focus:border-primary focus:ring-1 focus:ring-primary/50 transition" required></div>
                    <div><label for="duration" class="block text-sm font-medium text-gray-700 mb-1">مدت زمان</label><select id="duration" name="duration" class="w-full bg-white rounded-lg border border-gray-300 focus:border-primary focus:ring-1 focus:ring-primary/50 transition" required><option value="30" <?= (($edit_plan['duration_days'] ?? 0) == 30) ? 'selected' : '' ?>>۱ ماهه</option><option value="60" <?= (($edit_plan['duration_days'] ?? 0) == 60) ? 'selected' : '' ?>>۲ ماهه</option><option value="180" <?= (($edit_plan['duration_days'] ?? 0) == 180) ? 'selected' : '' ?>>۶ ماهه</option><option value="365" <?= (($edit_plan['duration_days'] ?? 0) == 365) ? 'selected' : '' ?>>۱ ساله</option></select></div>
                    <div><label for="traffic_gb" class="block text-sm font-medium text-gray-700 mb-1">ترافیک (GB)</label><input type="number" id="traffic_gb" name="traffic_gb" value="<?= htmlspecialchars($edit_plan['traffic_gb'] ?? '') ?>" class="w-full bg-white rounded-lg border border-gray-300 focus:border-primary focus:ring-1 focus:ring-primary/50 transition" required></div>
                    <div><label for="user_limit" class="block text-sm font-medium text-gray-700 mb-1">تعداد کاربر</label><input type="number" id="user_limit" name="user_limit" value="<?= htmlspecialchars($edit_plan['user_limit'] ?? '1') ?>" class="w-full bg-white rounded-lg border border-gray-300 focus:border-primary focus:ring-1 focus:ring-primary/50 transition" required></div>
                </div>
                <div class="pt-4 border-t space-y-4">
                    <label class="flex items-center space-x-3 space-x-reverse"><input type="checkbox" name="is_active" id="is_active" value="1" class="h-4 w-4 rounded border-gray-300 text-primary focus:ring-primary" <?= !isset($edit_plan) || ($edit_plan['is_active'] ?? 0) == 1 ? 'checked' : '' ?>><span class="text-sm font-medium text-gray-700">پلن برای خرید کاربران فعال باشد</span></label>
                    <label class="flex items-center space-x-3 space-x-reverse"><input type="checkbox" name="on_hold_enabled" id="on_hold_enabled" value="1" class="h-4 w-4 rounded border-gray-300 text-primary focus:ring-primary" <?= ($edit_plan['on_hold_enabled'] ?? 0) == 1 ? 'checked' : '' ?>><span class="text-sm font-medium text-gray-700">فعال‌سازی وضعیت On Hold</span></label>
                </div>
            </div>
            <div class="mt-6 flex items-center justify-end space-x-4 space-x-reverse">
                <button type="button" id="cancel-btn" class="bg-gray-200 text-gray-800 px-5 py-2 rounded-lg hover:bg-gray-300">لغو</button>
                <button type="submit" name="save_plan" id="save-btn" class="bg-primary text-white px-5 py-2 rounded-lg hover:bg-primary/90"></button>
            </div>
        </form>
    </div>
</div>
<script>
document.addEventListener('DOMContentLoaded', function() {
    const modal = document.getElementById('plan-modal'); const addPlanBtn = document.getElementById('add-plan-btn'); const closeModalBtn = document.getElementById('close-modal-btn'); const cancelBtn = document.getElementById('cancel-btn'); const form = document.getElementById('plan-form'); const modalTitle = document.getElementById('modal-title'); const saveBtn = document.getElementById('save-btn');
    const openModal = () => modal.classList.remove('hidden');
    const closeModal = () => { modal.classList.add('hidden'); const currentUrl = new URL(window.location.href); currentUrl.searchParams.delete('edit'); window.history.pushState({}, '', currentUrl.toString()); };
    addPlanBtn.addEventListener('click', () => { form.reset(); document.getElementById('plan_id').value = ''; document.getElementById('is_active').checked = true; modalTitle.textContent = 'افزودن پلن جدید'; saveBtn.textContent = 'افزودن پلن'; openModal(); });
    closeModalBtn.addEventListener('click', closeModal); cancelBtn.addEventListener('click', closeModal); modal.addEventListener('click', (e) => { if (e.target === modal) { closeModal(); } });
    <?php if (isset($_GET['edit']) && $edit_plan): ?> modalTitle.textContent = 'ویرایش پلن'; saveBtn.textContent = 'ذخیره تغییرات'; openModal(); <?php elseif (($message_type ?? '') === 'error' && isset($_POST['save_plan'])): ?> modalTitle.textContent = document.getElementById('plan_id').value ? 'ویرایش پلن' : 'افزودن پلن جدید'; saveBtn.textContent = document.getElementById('plan_id').value ? 'ذخیره تغییرات' : 'افزودن پلن'; openModal(); <?php endif; ?>
});
</script>
<?php include 'includes/footer.php'; ?>