<?php
require_once '../core/config.php';
require_once '../core/database.php';

// تاریخ پیش‌فرض: ۳۰ روز گذشته
$start_date = $_GET['start_date'] ?? date('Y-m-d', strtotime('-30 days'));
$end_date = $_GET['end_date'] ?? date('Y-m-d');

// کوئری پیچیده برای استخراج گزارش عملکرد هر نماینده در بازه زمانی مشخص
$sql = "
    SELECT
        r.id as reseller_id,
        r.username AS reseller_name,
        (SELECT COUNT(*) FROM users c WHERE c.reseller_id = r.id) as customer_count,
        COUNT(o.id) AS sales_count,
        IFNULL(SUM(o.price), 0) AS total_revenue
    FROM
        users r
    LEFT JOIN
        users c ON r.id = c.reseller_id
    LEFT JOIN
        orders o ON c.id = o.user_id AND (o.order_date BETWEEN ? AND ?)
    WHERE
        r.role = 'reseller'
    GROUP BY
        r.id, r.username
    ORDER BY
        total_revenue DESC;
";

$params = [$start_date . ' 00:00:00', $end_date . ' 23:59:59'];
$report_stmt = $pdo->prepare($sql);
$report_stmt->execute($params);
$report_data = $report_stmt->fetchAll(PDO::FETCH_ASSOC);

include 'includes/header.php';
include 'includes/sidebar.php';
?>

<main id="main-content" class="flex-1 p-6 mr-64 transition-all duration-300">
    <div class="mb-8">
        <h1 class="text-2xl font-bold text-gray-800">گزارش عملکرد نمایندگان</h1>
        <p class="text-gray-600 mt-1">عملکرد فروش هر نماینده را در بازه‌های زمانی دلخواه بررسی کنید.</p>
    </div>

    <div class="bg-white p-4 rounded-lg shadow-sm mb-6">
        <form action="report-resellers.php" method="GET" class="grid grid-cols-1 md:grid-cols-3 gap-4">
            <div>
                <label for="start_date" class="text-sm font-medium text-gray-700">از تاریخ</label>
                <input type="date" name="start_date" id="start_date" value="<?= htmlspecialchars($start_date) ?>" class="mt-1 w-full bg-gray-50 rounded-lg border-gray-300 text-sm" style="direction: ltr; text-align: right;">
            </div>
            <div>
                <label for="end_date" class="text-sm font-medium text-gray-700">تا تاریخ</label>
                <input type="date" name="end_date" id="end_date" value="<?= htmlspecialchars($end_date) ?>" class="mt-1 w-full bg-gray-50 rounded-lg border-gray-300 text-sm" style="direction: ltr; text-align: right;">
            </div>
            <div class="flex items-end">
                <button type="submit" class="w-full bg-primary text-white py-2 px-4 rounded-lg hover:bg-primary/90">نمایش گزارش</button>
            </div>
        </form>
    </div>
    
    <div class="bg-white rounded-lg shadow-sm p-6">
        <h3 class="font-semibold text-gray-800 mb-4">گزارش نمایندگان برای بازه انتخابی</h3>
        <div class="overflow-x-auto">
            <table class="w-full">
                <thead>
                    <tr class="border-b-2 border-gray-200">
                        <th class="text-right py-3 px-4 text-sm font-medium text-gray-500">نام نماینده</th>
                        <th class="text-center py-3 px-4 text-sm font-medium text-gray-500">تعداد مشتریان</th>
                        <th class="text-center py-3 px-4 text-sm font-medium text-gray-500">تعداد فروش</th>
                        <th class="text-right py-3 px-4 text-sm font-medium text-gray-500">مجموع درآمد (تومان)</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (empty($report_data)): ?>
                        <tr><td colspan="4" class="text-center py-6 text-gray-500">هیچ نماینده‌ای یافت نشد.</td></tr>
                    <?php else: ?>
                        <?php foreach ($report_data as $row): ?>
                            <tr class="border-b border-gray-100 hover:bg-gray-50">
                                <td class="py-3 px-4 font-semibold"><?= htmlspecialchars($row['reseller_name']) ?></td>
                                <td class="py-3 px-4 text-center font-mono text-lg"><?= number_format($row['customer_count']) ?></td>
                                <td class="py-3 px-4 text-center font-mono text-lg"><?= number_format($row['sales_count']) ?></td>
                                <td class="py-3 px-4 font-mono font-bold text-green-600 text-lg"><?= number_format($row['total_revenue']) ?></td>
                            </tr>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</main>

<?php include 'includes/footer.php'; ?>