<?php
require_once '../core/config.php';
require_once '../core/database.php';

// FIX 1: این بخش برای خواندن پیام موفقیت پس از رفرش اضافه شده است
$message = '';
$message_type = '';
if (isset($_SESSION['flash_message'])) {
    $message = $_SESSION['flash_message'];
    $message_type = $_SESSION['flash_message_type'] ?? 'success';
    unset($_SESSION['flash_message']);
    unset($_SESSION['flash_message_type']);
}

// این بخش از کد شما بدون تغییر باقی می‌ماند
$settings_stmt = $pdo->query("SELECT * FROM settings");
$settings = $settings_stmt->fetchAll(PDO::FETCH_KEY_PAIR);

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    try {
        $pdo->beginTransaction();
        $stmt = $pdo->prepare("UPDATE settings SET setting_value = ? WHERE setting_key = ?");

        // این بخش‌ها کاملاً کد خودتان هستند و بدون تغییر باقی مانده‌اند
        if (isset($_POST['settings'])) {
            foreach ($_POST['settings'] as $key => $value) {
                $stmt->execute([$value, $key]);
            }
        }
        $reseller_enabled = isset($_POST['reseller_system_enabled']) ? '1' : '0';
        $affiliate_enabled = isset($_POST['affiliate_system_enabled']) ? '1' : '0';
        $stmt->execute([$reseller_enabled, 'reseller_system_enabled']);
        $stmt->execute([$affiliate_enabled, 'affiliate_system_enabled']);
        $upload_dir = __DIR__ . '/../uploads/';
        if (!is_dir($upload_dir)) mkdir($upload_dir, 0755, true);
        $allowed_logo_types = ['image/png', 'image/jpeg', 'image/svg+xml', 'image/gif', 'image/webp'];
        $allowed_favicon_types = ['image/vnd.microsoft.icon', 'image/x-icon', 'image/png', 'image/svg+xml'];

        if (isset($_POST['delete_logo'])) {
            $logo_path = setting('site_logo');
            if (!empty($logo_path)) {
                $physical_path = __DIR__ . '/..' . $logo_path;
                if (file_exists($physical_path)) unlink($physical_path);
                $stmt->execute(['', 'site_logo']);
            }
        } elseif (isset($_FILES['logo']) && $_FILES['logo']['error'] === UPLOAD_ERR_OK) {
            if (!in_array($_FILES['logo']['type'], $allowed_logo_types)) throw new Exception('فرمت فایل لوگو مجاز نیست.');
            $logo_name = 'logo_' . time() . '.' . pathinfo($_FILES['logo']['name'], PATHINFO_EXTENSION);
            move_uploaded_file($_FILES['logo']['tmp_name'], $upload_dir . $logo_name);
            $stmt->execute(['/uploads/' . $logo_name, 'site_logo']);
        }

        if (isset($_POST['delete_favicon'])) {
            $favicon_path = setting('site_favicon');
            if (!empty($favicon_path)) {
                $physical_path = __DIR__ . '/..' . $favicon_path;
                if (file_exists($physical_path)) unlink($physical_path);
                $stmt->execute(['', 'site_favicon']);
            }
        } elseif (isset($_FILES['favicon']) && $_FILES['favicon']['error'] === UPLOAD_ERR_OK) {
            if (!in_array($_FILES['favicon']['type'], $allowed_favicon_types)) throw new Exception('فرمت فایل فاوآیکن مجاز نیست.');
            $favicon_name = 'favicon_' . time() . '.' . pathinfo($_FILES['favicon']['name'], PATHINFO_EXTENSION);
            move_uploaded_file($_FILES['favicon']['tmp_name'], $upload_dir . $favicon_name);
            $stmt->execute(['/uploads/' . $favicon_name, 'site_favicon']);
        }

        $pdo->commit();
        
        // FIX 2: به جای خواندن مجدد متغیرها، پیام را در سشن ذخیره و صفحه را رفرش می‌کنیم
        $_SESSION['flash_message'] = 'تنظیمات با موفقیت ذخیره شد.';
        $_SESSION['flash_message_type'] = 'success';
        header("Location: settings-general.php");
        exit;

    } catch (Exception $e) {
        $pdo->rollBack();
        $message = 'خطا در ذخیره تنظیمات: ' . $e->getMessage();
        $message_type = 'error';
    }
}

include 'includes/header.php';
include 'includes/sidebar.php';
?>
<style>
.switch { position: relative; display: inline-block; width: 44px; height: 24px; }
.switch input { opacity: 0; width: 0; height: 0; }
.slider { position: absolute; cursor: pointer; top: 0; left: 0; right: 0; bottom: 0; background-color: #ccc; transition: .4s; border-radius: 24px; }
.slider:before { position: absolute; content: ""; height: 18px; width: 18px; left: 3px; bottom: 3px; background-color: white; transition: .4s; border-radius: 50%; }
input:checked + .slider { background-color: #3b82f6; }
input:checked + .slider:before { transform: translateX(20px); }
</style>

<main id="main-content" class="flex-1 p-6 mr-64 transition-all duration-300">
    <div class="mb-8">
        <h1 class="text-2xl font-bold text-gray-800">تنظیمات عمومی</h1>
        <p class="text-gray-600 mt-1">اطلاعات کلی وبسایت خود را از این بخش مدیریت کنید.</p>
    </div>

    <?php if ($message): ?>
        <div class="mb-4 p-4 rounded-lg <?= $message_type === 'success' ? 'bg-green-100 text-green-800' : 'bg-red-100 text-red-800' ?>"><?= htmlspecialchars($message) ?></div>
    <?php endif; ?>

    <div class="bg-white rounded-lg shadow-sm">
        <form action="settings-general.php" method="POST" enctype="multipart/form-data">
            <div class="p-6 space-y-6">
                <div>
                    <label for="site_name" class="block text-sm font-medium text-gray-700">نام سایت</label>
                    <input type="text" name="settings[site_name]" id="site_name" value="<?= htmlspecialchars($settings['site_name'] ?? '') ?>" class="mt-1 block w-full bg-gray-50 rounded-lg border-gray-300">
                </div>
                <div>
                    <label for="site_logo_text" class="block text-sm font-medium text-gray-700">لوگو متنی</label>
                    <input type="text" name="settings[site_logo_text]" id="site_logo_text" value="<?= htmlspecialchars($settings['site_logo_text'] ?? '') ?>" class="mt-1 block w-full bg-gray-50 rounded-lg border-gray-300">
                    <p class="mt-1 text-xs text-gray-500">در صورتی که لوگوی تصویری آپلود نشده باشد، این متن نمایش داده می‌شود.</p>
                </div>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <div>
                        <label class="block text-sm font-medium text-gray-700">لوگوی سایت (تصویری)</label>
                        <div class="mt-2 flex items-center gap-4">
                            <?php if(!empty($settings['site_logo'])): ?>
                                <img src="<?= BASE_URL . ltrim($settings['site_logo'], '/') ?>" alt="لوگوی فعلی" class="h-12 bg-gray-100 p-1 rounded">
                                <button type="submit" name="delete_logo" class="text-xs text-red-600 hover:text-red-800" onclick="return confirm('آیا از حذف لوگوی تصویری مطمئن هستید؟')">حذف لوگو</button>
                            <?php endif; ?>
                        </div>
                        <input type="file" name="logo" class="mt-2 block w-full text-sm text-gray-500 file:mr-4 file:py-2 file:px-4 file:rounded-full file:border-0 file:text-sm file:font-semibold file:bg-violet-50 file:text-violet-700 hover:file:bg-violet-100">
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700">فاوآیکن سایت</label>
                        <div class="mt-2 flex items-center gap-4">
                             <?php if(!empty($settings['site_favicon'])): ?>
                                <img src="<?= BASE_URL . ltrim($settings['site_favicon'], '/') ?>" alt="فاوآیکن فعلی" class="h-12 w-12 bg-gray-100 p-1 rounded">
                                <button type="submit" name="delete_favicon" class="text-xs text-red-600 hover:text-red-800" onclick="return confirm('آیا از حذف فاوآیکن مطمئن هستید؟')">حذف فاوآیکن</button>
                            <?php endif; ?>
                        </div>
                        <input type="file" name="favicon" class="mt-2 block w-full text-sm text-gray-500 file:mr-4 file:py-2 file:px-4 file:rounded-full file:border-0 file:text-sm file:font-semibold file:bg-violet-50 file:text-violet-700 hover:file:bg-violet-100">
                    </div>
                </div>

                <div class="border-t pt-6 space-y-4">
                    <div class="flex items-center justify-between">
                        <span class="flex-grow flex flex-col">
                            <span class="text-sm font-medium text-gray-900">سیستم نمایندگی</span>
                            <span class="text-sm text-gray-500">به کاربران اجازه درخواست برای تبدیل شدن به نماینده را بده.</span>
                        </span>
                        <label class="switch">
                            <input type="checkbox" name="reseller_system_enabled" value="1" <?= ($settings['reseller_system_enabled'] ?? 0) == 1 ? 'checked' : '' ?>>
                            <span class="slider"></span>
                        </label>
                    </div>
                    <div class="flex items-center justify-between">
                        <span class="flex-grow flex flex-col">
                            <span class="text-sm font-medium text-gray-900">همکاری در فروش</span>
                            <span class="text-sm text-gray-500">سیستم همکاری در فروش و کسب درآمد را برای کاربران فعال کن.</span>
                        </span>
                        <label class="switch">
                            <input type="checkbox" name="affiliate_system_enabled" value="1" <?= ($settings['affiliate_system_enabled'] ?? 0) == 1 ? 'checked' : '' ?>>
                            <span class="slider"></span>
                        </label>
                    </div>
                </div>
            </div>
            <div class="p-6 bg-gray-50 flex justify-end">
                <button type="submit" name="save_settings" class="bg-primary text-white px-6 py-2 rounded-lg hover:bg-primary/90 transition-colors">ذخیره تنظیمات</button>
            </div>
        </form>
    </div>
</main>

<?php include 'includes/footer.php'; ?>