<?php
require_once '../core/config.php';
require_once '../core/database.php';

// مدیریت پیام‌های لحظه‌ای
$message = '';
$message_type = '';
if (isset($_SESSION['flash_message'])) {
    $message = $_SESSION['flash_message'];
    $message_type = $_SESSION['flash_message_type'] ?? 'success';
    unset($_SESSION['flash_message'], $_SESSION['flash_message_type']);
}

// پردازش فرم با منطق اصلاح شده
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    try {
        $pdo->beginTransaction();
        $stmt = $pdo->prepare("UPDATE settings SET setting_value = ? WHERE setting_key = ?");
        
        $settings_to_save = [
            'zarinpal_merchant_id' => trim($_POST['zarinpal_merchant_id'] ?? ''),
            'min_deposit' => (int)($_POST['min_deposit'] ?? 0),
            'max_deposit' => (int)($_POST['max_deposit'] ?? 0),
            'zarinpal_sandbox_enabled' => isset($_POST['zarinpal_sandbox_enabled']) ? '1' : '0'
        ];

        foreach ($settings_to_save as $key => $value) {
            $stmt->execute([$value, $key]);
        }

        $pdo->commit();
        $_SESSION['flash_message'] = 'تنظیمات پرداخت با موفقیت ذخیره شد.';
        $_SESSION['flash_message_type'] = 'success';

    } catch (Exception $e) {
        $pdo->rollBack();
        $_SESSION['flash_message'] = 'خطا: ' . $e->getMessage();
        $_SESSION['flash_message_type'] = 'error';
    }
    
    header("Location: settings-payment.php");
    exit;
}

// FIX: خواندن مستقیم و بدون واسطه تنظیمات از دیتابیس
$settings_stmt = $pdo->query("SELECT setting_key, setting_value FROM settings");
$settings = $settings_stmt->fetchAll(PDO::FETCH_KEY_PAIR);

include 'includes/header.php';
include 'includes/sidebar.php';
?>
<style>
.switch { position: relative; display: inline-block; width: 44px; height: 24px; }
.switch input { opacity: 0; width: 0; height: 0; }
.slider { position: absolute; cursor: pointer; top: 0; left: 0; right: 0; bottom: 0; background-color: #ccc; transition: .4s; border-radius: 24px; }
.slider:before { position: absolute; content: ""; height: 18px; width: 18px; left: 3px; bottom: 3px; background-color: white; transition: .4s; border-radius: 50%; }
input:checked + .slider { background-color: #3b82f6; }
input:checked + .slider:before { transform: translateX(20px); }
</style>

<main id="main-content" class="flex-1 p-6 mr-64 transition-all duration-300">
    <div class="mb-8">
        <h1 class="text-2xl font-bold text-gray-800">تنظیمات پرداخت و کیف پول</h1>
        <p class="text-gray-600 mt-1">اطلاعات درگاه پرداخت و قوانین شارژ کیف پول را مدیریت کنید.</p>
    </div>

    <?php if ($message): ?>
        <div class="mb-4 p-4 rounded-lg <?= $message_type === 'success' ? 'bg-green-100 text-green-800' : 'bg-red-100 text-red-800' ?>"><?= htmlspecialchars($message) ?></div>
    <?php endif; ?>

    <div class="bg-white rounded-lg shadow-sm">
        <form action="settings-payment.php" method="POST">
            <div class="p-6 space-y-6">
                <div class="border-b pb-6">
                    <h3 class="text-lg font-semibold text-gray-800">تنظیمات درگاه زرین‌پال</h3>
                    <div class="mt-4">
                        <label for="zarinpal_merchant_id" class="block text-sm font-medium text-gray-700">مرچنت کد زرین‌پال</label>
                        <input type="text" name="zarinpal_merchant_id" id="zarinpal_merchant_id" value="<?= htmlspecialchars($settings['zarinpal_merchant_id'] ?? '') ?>" class="mt-1 block w-full bg-gray-50 rounded-lg border-gray-300" placeholder="کد ۳۶ کاراکتری دریافت شده از زرین‌پال">
                    </div>
                    <div class="mt-4">
                         <label class="flex items-center space-x-3 space-x-reverse cursor-pointer">
                            <div class="switch">
                                <input type="checkbox" name="zarinpal_sandbox_enabled" value="1" <?= ((int)($settings['zarinpal_sandbox_enabled'] ?? 0)) === 1 ? 'checked' : '' ?>>
                                <span class="slider"></span>
                            </div>
                            <span class="text-sm font-medium text-gray-700">فعال‌سازی حالت آزمایشی (سندباکس)</span>
                        </label>
                    </div>
                </div>
                <div>
                    <h3 class="text-lg font-semibold text-gray-800">قوانین کیف پول</h3>
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mt-4">
                        <div>
                            <label for="min_deposit" class="block text-sm font-medium text-gray-700">حداقل مبلغ شارژ (تومان)</label>
                            <input type="number" name="min_deposit" id="min_deposit" value="<?= htmlspecialchars($settings['min_deposit'] ?? '10000') ?>" class="mt-1 block w-full bg-gray-50 rounded-lg border-gray-300">
                        </div>
                        <div>
                            <label for="max_deposit" class="block text-sm font-medium text-gray-700">حداکثر مبلغ شارژ (تومان)</label>
                            <input type="number" name="max_deposit" id="max_deposit" value="<?= htmlspecialchars($settings['max_deposit'] ?? '1000000') ?>" class="mt-1 block w-full bg-gray-50 rounded-lg border-gray-300">
                        </div>
                    </div>
                </div>
            </div>
            <div class="p-6 bg-gray-50 flex justify-end">
                <button type="submit" class="bg-primary text-white px-6 py-2 rounded-lg hover:bg-primary/90">ذخیره تنظیمات</button>
            </div>
        </form>
    </div>
</main>

<?php include 'includes/footer.php'; ?>