<?php
require_once '../core/config.php';
require_once '../core/database.php';

// اگر سیستم نمایندگی غیرفعال بود، اجازه دسترسی نده
if (!(bool)setting('reseller_system_enabled', 0)) {
    // برای جلوگیری از خطای "headers already sent" قبل از include کردن هدر، از die استفاده می‌کنیم.
    // ابتدا هدر و سایدبار را include می‌کنیم تا ظاهر صفحه حفظ شود.
    include 'includes/header.php';
    include 'includes/sidebar.php';
    echo '<main id="main-content" class="flex-1 p-6 mr-64 transition-all duration-300">';
    echo '<div class="bg-yellow-50 border-r-4 border-yellow-400 p-4 rounded-lg">
            <div class="flex">
                <div class="py-1"><i class="ri-information-line text-yellow-600 ri-lg"></i></div>
                <div class="mr-3">
                    <p class="font-bold text-yellow-800">سیستم نمایندگی غیرفعال است</p>
                    <p class="text-sm text-yellow-700 mt-1">
                        برای دسترسی به این بخش، ابتدا باید سیستم نمایندگی را از
                        <a href="settings-general.php" class="underline hover:text-yellow-900">تنظیمات عمومی</a>
                        فعال کنید.
                    </p>
                </div>
            </div>
          </div></main>';
    include 'includes/footer.php';
    exit(); // اجرای کامل اسکریپت را متوقف می‌کنیم
}


// پردازش فرم
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    try {
        $pdo->beginTransaction();
        $stmt = $pdo->prepare("UPDATE settings SET setting_value = ? WHERE setting_key = ?");
        
        $settings_to_save = [
            'reseller_discount_percent' => filter_input(INPUT_POST, 'reseller_discount_percent', FILTER_VALIDATE_INT, ['options' => ['min_range' => 0, 'max_range' => 100]]),
            'price_per_gb_addon' => filter_input(INPUT_POST, 'price_per_gb_addon', FILTER_VALIDATE_INT, ['options' => ['min_range' => 0]]),
            'price_per_day_addon' => filter_input(INPUT_POST, 'price_per_day_addon', FILTER_VALIDATE_INT, ['options' => ['min_range' => 0]])
        ];

        foreach ($settings_to_save as $key => $value) {
            if ($value !== false && $value !== null) {
                $stmt->execute([$value, $key]);
            }
        }

        $pdo->commit();
        $_SESSION['flash_message'] = 'تنظیمات با موفقیت ذخیره شد.';
        $_SESSION['flash_message_type'] = 'success';

    } catch (Exception $e) {
        $pdo->rollBack();
        $_SESSION['flash_message'] = 'خطا: ' . $e->getMessage();
        $_SESSION['flash_message_type'] = 'error';
    }
    header("Location: settings-reseller.php");
    exit;
}

$message = '';
if (isset($_SESSION['flash_message'])) {
    $message = '<div class="mb-4 p-4 rounded-lg ' . (($_SESSION['flash_message_type'] ?? '') === 'success' ? 'bg-green-100 text-green-800' : 'bg-red-100 text-red-800') . '">' . htmlspecialchars($_SESSION['flash_message']) . '</div>';
    unset($_SESSION['flash_message'], $_SESSION['flash_message_type']);
}

$settings = setting(null);
include 'includes/header.php';
include 'includes/sidebar.php';
?>

<main id="main-content" class="flex-1 p-6 mr-64 transition-all duration-300">
    <div class="mb-8">
        <h1 class="text-2xl font-bold text-gray-800">تنظیمات نمایندگی</h1>
        <p class="text-gray-600 mt-1">تنظیمات کلی و قیمت‌گذاری افزودنی‌ها برای نمایندگان را در این بخش مدیریت کنید.</p>
    </div>

    <?= $message ?>

    <div class="bg-white rounded-lg shadow-sm">
        <form action="settings-reseller.php" method="POST">
            <div class="p-6 space-y-6">
                <div>
                    <h3 class="text-lg font-semibold text-gray-800 border-b pb-3">تخفیف عمومی نمایندگان</h3>
                    <div class="mt-4">
                        <label for="reseller_discount_percent" class="block text-sm font-medium text-gray-700">درصد تخفیف روی پلن‌ها</label>
                        <div class="relative mt-1">
                            <input type="number" name="reseller_discount_percent" id="reseller_discount_percent" 
                                   value="<?= htmlspecialchars($settings['reseller_discount_percent'] ?? '10') ?>" 
                                   class="w-full bg-gray-50 rounded-lg border-gray-300 pl-8"
                                   min="0" max="100" required>
                            <div class="pointer-events-none absolute inset-y-0 left-0 flex items-center pl-3">
                                <span class="text-gray-500 sm:text-sm">%</span>
                            </div>
                        </div>
                    </div>
                </div>

                <div>
                    <h3 class="text-lg font-semibold text-gray-800 border-b pb-3">قیمت‌گذاری افزودنی‌ها برای نماینده</h3>
                    <p class="mt-2 text-xs text-gray-500">
                        هزینه‌ای که نماینده برای افزودن دستی روز/حجم به سرویس مشتریانش پرداخت می‌کند.
                    </p>
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mt-4">
                        <div>
                            <label for="price_per_day_addon" class="block text-sm font-medium text-gray-700">هزینه هر ۱ روز افزودنی (تومان)</label>
                            <input type="number" name="price_per_day_addon" id="price_per_day_addon" value="<?= htmlspecialchars($settings['price_per_day_addon'] ?? '1000') ?>" class="mt-1 block w-full bg-gray-50 rounded-lg border-gray-300" min="0">
                        </div>
                        <div>
                            <label for="price_per_gb_addon" class="block text-sm font-medium text-gray-700">هزینه هر ۱ گیگابایت افزودنی (تومان)</label>
                            <input type="number" name="price_per_gb_addon" id="price_per_gb_addon" value="<?= htmlspecialchars($settings['price_per_gb_addon'] ?? '3000') ?>" class="mt-1 block w-full bg-gray-50 rounded-lg border-gray-300" min="0">
                        </div>
                    </div>
                </div>

            </div>
            <div class="p-6 bg-gray-50 flex justify-end">
                <button type="submit" class="bg-primary text-white px-6 py-2 rounded-lg hover:bg-primary/90">ذخیره تنظیمات</button>
            </div>
        </form>
    </div>
</main>

<?php include 'includes/footer.php'; ?>