<?php
require_once '../core/database.php';
$settings_stmt = $pdo->query("SELECT * FROM settings");
$settings = $settings_stmt->fetchAll(PDO::FETCH_KEY_PAIR);

$message = '';
$message_type = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $new_settings = $_POST['settings'];
    
    if (isset($new_settings['marzban_protocols']) && is_array($new_settings['marzban_protocols'])) {
        $new_settings['marzban_protocols'] = implode(',', $new_settings['marzban_protocols']);
    } else {
        $new_settings['marzban_protocols'] = '';
    }

    try {
        $pdo->beginTransaction();
        $stmt = $pdo->prepare("UPDATE settings SET setting_value = ? WHERE setting_key = ?");
        foreach ($new_settings as $key => $value) {
            if ($key === 'marzban_password' && empty($value)) {
                continue;
            }
            $stmt->execute([$value, $key]);
        }
        $pdo->commit();
        $message = 'تنظیمات با موفقیت ذخیره شد.';
        $message_type = 'success';
        
        $settings_stmt = $pdo->query("SELECT * FROM settings");
        $settings = $settings_stmt->fetchAll(PDO::FETCH_KEY_PAIR);

    } catch (Exception $e) {
        $pdo->rollBack();
        $message = 'خطا در ذخیره تنظیمات: ' . $e->getMessage();
        $message_type = 'error';
    }
}

$selected_protocols = explode(',', $settings['marzban_protocols'] ?? 'vless');

include 'includes/header.php';
include 'includes/sidebar.php';
?>

<main id="main-content" class="flex-1 p-6 mr-64 transition-all duration-300">
    <div class="mb-8">
        <h1 class="text-2xl font-bold text-gray-800">تنظیمات سرور (مرزبان)</h1>
        <p class="text-gray-600 mt-1">اطلاعات اتصال به پنل مرزبان و تنظیمات ساخت اکانت را در اینجا مدیریت کنید.</p>
    </div>

    <?php if ($message): ?>
        <div class="mb-4 p-4 rounded-lg <?= $message_type === 'success' ? 'bg-green-100 text-green-800' : 'bg-red-100 text-red-800' ?>">
            <?= htmlspecialchars($message) ?>
        </div>
    <?php endif; ?>

    <div class="bg-white rounded-lg shadow-sm p-6">
        <form action="settings-server.php" method="POST">
            <div class="space-y-6">
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <div>
                        <label for="marzban_url" class="block text-sm font-medium text-gray-700">آدرس پنل مرزبان</label>
                        <input type="text" name="settings[marzban_url]" id="marzban_url" value="<?= htmlspecialchars($settings['marzban_url'] ?? '') ?>" class="mt-1 block w-full bg-gray-50 rounded-lg border-gray-300">
                    </div>
                    <div>
                        <label for="marzban_username" class="block text-sm font-medium text-gray-700">نام کاربری مرزبان</label>
                        <input type="text" name="settings[marzban_username]" id="marzban_username" value="<?= htmlspecialchars($settings['marzban_username'] ?? '') ?>" class="mt-1 block w-full bg-gray-50 rounded-lg border-gray-300">
                    </div>
                    <div>
                        <label for="marzban_password" class="block text-sm font-medium text-gray-700">رمز عبور مرزبان</label>
                        <input type="password" name="settings[marzban_password]" id="marzban_password" class="mt-1 block w-full bg-gray-50 rounded-lg border-gray-300" placeholder="برای عدم تغییر، خالی بگذارید">
                    </div>
                     <div>
                        <label for="marzban_user_prefix" class="block text-sm font-medium text-gray-700">پیشوند نام کاربری اکانت‌ها</label>
                        <input type="text" name="settings[marzban_user_prefix]" id="marzban_user_prefix" value="<?= htmlspecialchars($settings['marzban_user_prefix'] ?? 'user_') ?>" class="mt-1 block w-full bg-gray-50 rounded-lg border-gray-300">
                    </div>
                </div>
                <hr/>
                <div>
                    <h3 class="text-lg font-medium leading-6 text-gray-900">تنظیمات ساخت اکانت</h3>
                    <div class="mt-4 space-y-4">
                        <label class="block text-sm font-medium text-gray-700">پروتکل‌های فعال</label>
                        <div class="flex flex-wrap gap-4">
                            <?php 
                                $all_protocols = ['Vmess', 'Vless', 'Trojan', 'Shadowsocks'];
                                foreach ($all_protocols as $protocol): 
                                    $protocol_lower = strtolower($protocol);
                            ?>
                                <label class="flex items-center space-x-2 space-x-reverse">
                                    <input type="checkbox" name="settings[marzban_protocols][]" value="<?= $protocol_lower ?>" 
                                           class="h-4 w-4 rounded border-gray-300 text-primary focus:ring-primary"
                                           <?= in_array($protocol_lower, $selected_protocols) ? 'checked' : '' ?>>
                                    <span><?= $protocol ?></span>
                                </label>
                            <?php endforeach; ?>
                        </div>
                    </div>
                </div>
            </div>
            <div class="pt-5 mt-5 border-t">
                <div class="flex justify-end">
                    <button type="submit" class="bg-primary text-white px-6 py-2 rounded-lg hover:bg-primary/90 transition-colors">ذخیره تنظیمات</button>
                </div>
            </div>
        </form>
    </div>
</main>

<?php include 'includes/footer.php'; ?>