<?php
require_once '../core/config.php';
require_once '../core/database.php';

// کوئری برای دریافت تمام تیکت‌ها به همراه نام کاربری که تیکت را ارسال کرده
$sql = "SELECT t.*, u.username 
        FROM tickets t 
        JOIN users u ON t.user_id = u.id 
        ORDER BY t.last_updated DESC";
$stmt = $pdo->query($sql);
$tickets = $stmt->fetchAll(PDO::FETCH_ASSOC);

$status_map = [ 'open' => ['text' => 'باز', 'class' => 'bg-blue-100 text-blue-800'], 'answered' => ['text' => 'پاسخ داده شده', 'class' => 'bg-green-100 text-green-800'], 'customer-reply' => ['text' => 'پاسخ مشتری', 'class' => 'bg-yellow-100 text-yellow-800'], 'closed' => ['text' => 'بسته شده', 'class' => 'bg-gray-200 text-gray-800'] ];
$priority_map = [ 'low' => 'کم', 'medium' => 'متوسط', 'high' => 'زیاد' ];
$department_map = ['support' => 'پشتیبانی', 'sales' => 'فروش', 'technical' => 'فنی'];

include 'includes/header.php';
include 'includes/sidebar.php';
?>

<main id="main-content" class="flex-1 p-6 mr-64 transition-all duration-300">
    <div class="mb-8">
        <h1 class="text-2xl font-bold text-gray-800">مدیریت تیکت‌های پشتیبانی</h1>
    </div>

    <div class="bg-white rounded-lg shadow-sm p-6">
        <div class="overflow-x-auto">
            <table class="w-full">
                <thead>
                    <tr class="border-b-2 border-gray-200">
                        <th class="text-right py-3 px-4 text-sm font-medium text-gray-500">کاربر</th>
                        <th class="text-right py-3 px-4 text-sm font-medium text-gray-500">موضوع</th>
                        <th class="text-right py-3 px-4 text-sm font-medium text-gray-500">دپارتمان</th>
                        <th class="text-right py-3 px-4 text-sm font-medium text-gray-500">اولویت</th>
                        <th class="text-right py-3 px-4 text-sm font-medium text-gray-500">وضعیت</th>
                        <th class="text-right py-3 px-4 text-sm font-medium text-gray-500">آخرین بروزرسانی</th>
                        <th class="text-center py-3 px-4 text-sm font-medium text-gray-500"></th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (empty($tickets)): ?>
                        <tr><td colspan="7" class="text-center py-10 text-gray-500">هیچ تیکتی یافت نشد.</td></tr>
                    <?php else: ?>
                        <?php foreach ($tickets as $ticket): ?>
                            <tr class="border-b border-gray-100 hover:bg-gray-50">
                                <td class="py-3 px-4 text-sm font-semibold"><?= htmlspecialchars($ticket['username']) ?></td>
                                <td class="py-3 px-4 text-sm"><?= htmlspecialchars($ticket['subject']) ?></td>
                                <td class="py-3 px-4 text-sm"><?= $department_map[$ticket['department']] ?? '' ?></td>
                                <td class="py-3 px-4 text-sm"><?= $priority_map[$ticket['priority']] ?? '' ?></td>
                                <td class="py-3 px-4 text-sm"><span class="px-2 py-1 text-xs rounded-full <?= $status_map[$ticket['status']]['class'] ?? '' ?>"><?= $status_map[$ticket['status']]['text'] ?? '' ?></span></td>
                                <td class="py-3 px-4 text-sm text-gray-500"><?= date("Y/m/d H:i", strtotime($ticket['last_updated'])) ?></td>
                                <td class="py-3 px-4 text-center"><a href="view_ticket.php?id=<?= $ticket['id'] ?>" class="text-primary hover:text-primary/80 font-semibold text-sm">مشاهده و پاسخ</a></td>
                            </tr>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</main>

<?php include 'includes/footer.php'; ?>