<?php
require_once '../core/config.php'; 
require_once '../core/database.php';
use App\MarzbanAPI;

if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'reseller') {
    header("Location: ../login.php");
    exit();
}
$reseller_id = $_SESSION['user_id'];
$error_message = '';

$reseller_stmt = $pdo->prepare("SELECT wallet_balance, user_prefix FROM users WHERE id = ?");
$reseller_stmt->execute([$reseller_id]);
$reseller = $reseller_stmt->fetch(PDO::FETCH_ASSOC);

$discount_percent = (int)setting('reseller_discount_percent', 0);

if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['buy_plan'])) {
    $plan_id = $_POST['plan_id'];
    $target_user_id = $_POST['target_user_id'];

    $target_user_stmt = $pdo->prepare("SELECT id FROM users WHERE id = ? AND reseller_id = ?");
    $target_user_stmt->execute([$target_user_id, $reseller_id]);
    $target_user = $target_user_stmt->fetch(PDO::FETCH_ASSOC);

    $plan_stmt = $pdo->prepare("SELECT * FROM plans WHERE id = ? AND is_active = 1");
    $plan_stmt->execute([$plan_id]);
    $plan = $plan_stmt->fetch(PDO::FETCH_ASSOC);

    if ($reseller && $plan && $target_user) {
        $discounted_price = floor($plan['price'] * (1 - ($discount_percent / 100)));
        
        if ($reseller['wallet_balance'] >= $discounted_price) {
            $prefix = !empty($reseller['user_prefix']) ? $reseller['user_prefix'] : setting('marzban_user_prefix', 'user_');
            $marzban_username = $prefix . substr(uniqid(), -6);
            
            $marzban_api = new MarzbanAPI();
            $on_hold_status = ($plan['on_hold_enabled'] == 1);
            $marzban_response = $marzban_api->createUser($marzban_username, (int)$plan['traffic_gb'], (int)$plan['duration_days'], $on_hold_status);

            if (isset($marzban_response['username'])) {
                $new_balance = $reseller['wallet_balance'] - $discounted_price;
                $pdo->prepare("UPDATE users SET wallet_balance = ? WHERE id = ?")->execute([$new_balance, $reseller_id]);
                
                $sub_link = $marzban_response['subscription_url'] ?? 'لینک یافت نشد';
                $expiry_date_db = ($plan['duration_days'] > 0) ? date('Y-m-d H:i:s', time() + ((int)$plan['duration_days'] * 86400)) : null;
                $pdo->prepare("INSERT INTO orders (user_id, plan_id, marzban_username, sub_link, price, expiry_date) VALUES (?, ?, ?, ?, ?, ?)")
                    ->execute([$target_user_id, $plan_id, $marzban_username, $sub_link, $discounted_price, $expiry_date_db]);
                
                $_SESSION['flash_message'] = "سرویس جدید با موفقیت برای کاربر خریداری شد!";
                header("Location: orders.php");
                exit();
            } else {
                $error_message = "خطا در ایجاد سرویس: " . ($marzban_response['error'] ?? 'پاسخ نامعتبر');
            }
        } else {
            $error_message = "موجودی کیف پول شما برای خرید این پلن کافی نیست.";
        }
    } else {
        $error_message = "کاربر یا پلن انتخاب شده نامعتبر است.";
    }
}

$sub_users_stmt = $pdo->prepare("SELECT id, username FROM users WHERE reseller_id = ? ORDER BY username");
$sub_users_stmt->execute([$reseller_id]);
$sub_users_list = $sub_users_stmt->fetchAll(PDO::FETCH_ASSOC);
$plans = $pdo->query("SELECT * FROM plans WHERE is_active = 1 ORDER BY price ASC")->fetchAll(PDO::FETCH_ASSOC);

include 'includes/header.php';
include 'includes/sidebar.php';
?>

<main id="main-content" class="flex-1 p-6 mr-64 transition-all duration-300">
    <div class="mb-8">
        <h1 class="text-2xl font-bold text-gray-800">خرید سرویس برای کاربر</h1>
        <p class="text-gray-600 mt-1">کاربر و پلن مورد نظر را انتخاب کرده و سرویس را با تخفیف نمایندگی خریداری کنید.</p>
    </div>

    <?php if (!empty($error_message)): ?>
        <div class="mb-6 p-4 rounded-lg bg-red-100 text-red-800 shadow"><?= htmlspecialchars($error_message) ?></div>
    <?php endif; ?>

    <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
        <div class="lg:col-span-1 bg-white p-6 rounded-lg shadow-sm">
            <h3 class="text-lg font-semibold mb-4 border-b pb-3">فرم خرید سرویس</h3>
            <form action="buy-service.php" method="POST" onsubmit="return confirm('آیا از خرید این سرویس با کسر هزینه از کیف پول خود مطمئن هستید؟')">
                <div class="space-y-4">
                    <div>
                        <label for="target_user_id" class="block text-sm font-medium text-gray-700">۱. انتخاب کاربر</label>
                        <select name="target_user_id" id="target_user_id" class="mt-1 w-full bg-gray-50 rounded-lg border-gray-300" required>
                            <option value="">-- یک کاربر را انتخاب کنید --</option>
                            <?php foreach($sub_users_list as $user): ?>
                                <option value="<?= $user['id'] ?>"><?= htmlspecialchars($user['username']) ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div>
                        <label for="plan_id" class="block text-sm font-medium text-gray-700">۲. انتخاب پلن</label>
                        <select name="plan_id" id="plan_id" class="mt-1 w-full bg-gray-50 rounded-lg border-gray-300" required>
                             <option value="">-- یک پلن را انتخاب کنید --</option>
                            <?php foreach($plans as $plan): ?>
                                <option value="<?= $plan['id'] ?>"><?= htmlspecialchars($plan['name']) ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div class="pt-2">
                        <button type="submit" name="buy_plan" class="w-full bg-primary text-white py-3 rounded-lg font-semibold hover:bg-primary/90 transition-all duration-300">ایجاد و فعالسازی سرویس</button>
                    </div>
                </div>
            </form>
        </div>
        <div class="lg:col-span-2 bg-white p-6 rounded-lg shadow-sm">
            <h3 class="text-lg font-semibold mb-4 border-b pb-3">لیست قیمت پلن‌ها (با تخفیف نمایندگی <?= $discount_percent ?>%)</h3>
            <ul class="space-y-2 max-h-96 overflow-y-auto">
                <?php if(empty($plans)): ?>
                    <p class="text-center text-gray-500 py-4">هیچ پلن فعالی برای فروش وجود ندارد.</p>
                <?php else: ?>
                    <?php foreach($plans as $plan): ?>
                        <li class="flex justify-between items-center p-3 bg-gray-50 rounded-lg hover:bg-gray-100">
                            <div>
                                <p class="font-semibold text-gray-800"><?= htmlspecialchars($plan['name']) ?></p>
                                <p class="text-xs text-gray-500 mt-1">
                                    <span><?= $plan['traffic_gb'] ?> گیگابایت</span> | <span><?= $plan['duration_days'] ?> روزه</span>
                                </p>
                            </div>
                            <div class="text-left font-mono">
                                <span class="line-through text-gray-400 text-sm"><?= number_format($plan['price']) ?></span>
                                <strong class="text-green-600 mr-2 text-lg"><?= number_format(floor($plan['price'] * (1 - ($discount_percent / 100)))) ?></strong>
                                <span class="text-xs">تومان</span>
                            </span>
                        </li>
                    <?php endforeach; ?>
                <?php endif; ?>
            </ul>
        </div>
    </div>
</main>
<?php include 'includes/footer.php'; ?>