<?php 
require_once '../core/config.php';
require_once '../core/database.php';
include 'includes/header.php'; // این فایل شامل بررسی لاگین و نقش کاربری است
include 'includes/sidebar.php'; 

$reseller_id = $_SESSION['user_id'];

// دریافت آمار مربوط به نماینده
// 1. تعداد کاربران زیرمجموعه
$user_count = $pdo->prepare("SELECT COUNT(*) FROM users WHERE reseller_id = ?");
$user_count->execute([$reseller_id]);
$total_sub_users = $user_count->fetchColumn();

// 2. تعداد سرویس‌های فعال فروخته شده
$services_count = $pdo->prepare("
    SELECT COUNT(*) 
    FROM orders o
    JOIN users u ON o.user_id = u.id
    WHERE u.reseller_id = ? AND o.status = 'active' AND o.expiry_date > NOW()
");
$services_count->execute([$reseller_id]);
$total_active_services = $services_count->fetchColumn();

// 3. مجموع فروش نماینده
$sales_sum = $pdo->prepare("
    SELECT SUM(o.price)
    FROM orders o
    JOIN users u ON o.user_id = u.id
    WHERE u.reseller_id = ?
");
$sales_sum->execute([$reseller_id]);
$total_sales = $sales_sum->fetchColumn();
?>

<main id="main-content" class="flex-1 p-6 mr-64 transition-all duration-300">
    <div class="mb-8">
        <h1 class="text-2xl font-bold text-gray-800">داشبورد نمایندگی</h1>
        <p class="text-gray-600 mt-1">خوش آمدید! در اینجا می‌توانید خلاصه‌ای از عملکرد خود را مشاهده کنید.</p>
    </div>
    
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
        <div class="bg-white rounded-lg shadow-sm p-6 flex items-center justify-between">
            <div>
                <p class="text-gray-500 text-sm">کاربران شما</p>
                <h3 class="text-3xl font-bold text-gray-800 mt-1"><?= number_format($total_sub_users) ?></h3>
            </div>
            <div class="w-12 h-12 rounded-full bg-blue-50 text-primary flex items-center justify-center"><i class="ri-group-line ri-xl"></i></div>
        </div>
        <div class="bg-white rounded-lg shadow-sm p-6 flex items-center justify-between">
            <div>
                <p class="text-gray-500 text-sm">سرویس‌های فعال</p>
                <h3 class="text-3xl font-bold text-gray-800 mt-1"><?= number_format($total_active_services) ?></h3>
            </div>
            <div class="w-12 h-12 rounded-full bg-green-50 text-green-500 flex items-center justify-center"><i class="ri-server-line ri-xl"></i></div>
        </div>
        <div class="bg-white rounded-lg shadow-sm p-6 flex items-center justify-between">
            <div>
                <p class="text-gray-500 text-sm">مجموع فروش</p>
                <h3 class="text-3xl font-bold text-gray-800 mt-1"><?= number_format($total_sales ?? 0) ?></h3>
            </div>
            <div class="w-12 h-12 rounded-full bg-purple-50 text-purple-500 flex items-center justify-center"><i class="ri-shopping-bag-3-line ri-xl"></i></div>
        </div>
    </div>
</main>

<?php include 'includes/footer.php'; ?>