<?php
require_once '../core/config.php';
require_once '../core/database.php';

// اطمینان از لاگین بودن کاربر
if (!isset($_SESSION['user_id'])) {
    header("Location: ../login.php");
    exit();
}
$user_id = $_SESSION['user_id'];

// دریافت تمام اعلان‌های این کاربر از دیتابیس
$stmt = $pdo->prepare("SELECT * FROM notifications WHERE user_id = ? ORDER BY created_at DESC");
$stmt->execute([$user_id]);
$notifications = $stmt->fetchAll(PDO::FETCH_ASSOC);

// پس از مشاهده، تمام اعلان‌های این کاربر را به حالت "خوانده شده" تغییر می‌دهیم
$update_stmt = $pdo->prepare("UPDATE notifications SET is_read = 1 WHERE user_id = ? AND is_read = 0");
$update_stmt->execute([$user_id]);


include 'includes/header.php';
include 'includes/sidebar.php'; 
?>

<main id="main-content" class="flex-1 p-6 mr-64 transition-all duration-300">
    <div class="mb-8">
        <h1 class="text-2xl font-bold text-gray-800">مرکز اطلاع‌رسانی</h1>
        <p class="text-gray-600 mt-1">تمام پیام‌ها و یادآوری‌های شما در اینجا قرار می‌گیرد.</p>
    </div>

    <div class="bg-white rounded-lg shadow-sm">
        <div class="p-6 space-y-4">
            <?php if (empty($notifications)): ?>
                <div class="text-center py-10 text-gray-500">
                    <i class="ri-mail-open-line text-5xl"></i>
                    <p class="mt-2">شما هیچ اعلان جدیدی ندارید.</p>
                </div>
            <?php else: ?>
                <?php foreach ($notifications as $notification): ?>
                    <a href="<?= htmlspecialchars($notification['link'] ?? '#') ?>" 
                       class="block p-4 rounded-lg transition-colors <?= $notification['is_read'] ? 'bg-gray-50 hover:bg-gray-100' : 'bg-blue-50 hover:bg-blue-100' ?>">
                        <div class="flex items-start">
                            <div class="w-8 h-8 flex-shrink-0 flex items-center justify-center rounded-full bg-primary/10 text-primary mt-1">
                                <i class="ri-information-line ri-lg"></i>
                            </div>
                            <div class="mr-4 flex-grow">
                                <p class="font-semibold text-gray-800"><?= htmlspecialchars($notification['title']) ?></p>
                                <p class="text-sm text-gray-600 mt-1"><?= htmlspecialchars($notification['message']) ?></p>
                                <p class="text-xs text-gray-400 mt-2"><?= date("Y/m/d H:i", strtotime($notification['created_at'])) ?></p>
                            </div>
                            <?php if (!$notification['is_read']): ?>
                                <div class="w-2.5 h-2.5 bg-primary rounded-full flex-shrink-0" title="جدید"></div>
                            <?php endif; ?>
                        </div>
                    </a>
                <?php endforeach; ?>
            <?php endif; ?>
        </div>
    </div>
</main>

<?php include 'includes/footer.php'; ?>