<?php
function isUserPageActive($pageName) {
    $current_page = basename($_SERVER['PHP_SELF']);
    if ($pageName === 'services' && in_array($current_page, ['my-services.php', 'buy-service.php', 'renew-service.php'])) {
        return 'active';
    }
    if ($pageName === 'tickets.php' && in_array($current_page, ['tickets.php', 'new_ticket.php', 'view_ticket.php'])) {
        return 'active';
    }
    if ($pageName === 'wallet' && in_array($current_page, ['charge-wallet.php', 'transactions.php'])) {
        return 'active';
    }
    if ($current_page == $pageName) {
        return 'active';
    }
    return '';
}
$is_affiliate_system_enabled = (bool)setting('affiliate_system_enabled', 0);
?>
<aside id="sidebar" class="bg-white w-64 shadow-sm fixed h-[calc(100vh-60px)] overflow-y-auto transition-all duration-300 z-10">
    <nav class="py-4">
        <ul>
            <li>
                <a href="dashboard.php" class="sidebar-item flex items-center px-4 py-3 text-gray-700 hover:text-primary <?= isUserPageActive('dashboard.php'); ?>">
                    <div class="w-8 flex items-center justify-center ml-3"><i class="ri-dashboard-line ri-lg"></i></div>
                    <span>داشبورد</span>
                </a>
            </li>
            <li>
                <button class="sidebar-item submenu-toggle w-full flex items-center justify-between px-4 py-3 text-gray-700 hover:text-primary <?= isUserPageActive('services'); ?>">
                    <div class="flex items-center">
                        <div class="w-8 flex items-center justify-center ml-3"><i class="ri-server-line ri-lg"></i></div>
                        <span>سرویس ها</span>
                    </div>
                    <i class="ri-arrow-down-s-line transition-transform duration-200"></i>
                </button>
                <ul class="submenu bg-gray-50 pr-8">
                    <li><a href="buy-service.php" class="block py-2 px-4 text-sm text-gray-700 hover:text-primary">خرید سرویس</a></li>
                    <li><a href="my-services.php" class="block py-2 px-4 text-sm text-gray-700 hover:text-primary">سرویس های من</a></li>
                </ul>
            </li>
            <li>
                <button class="sidebar-item submenu-toggle w-full flex items-center justify-between px-4 py-3 text-gray-700 hover:text-primary <?= isUserPageActive('wallet'); ?>">
                    <div class="flex items-center">
                        <div class="w-8 flex items-center justify-center ml-3"><i class="ri-wallet-3-line ri-lg"></i></div>
                        <span>کیف پول</span>
                    </div>
                    <i class="ri-arrow-down-s-line transition-transform duration-200"></i>
                </button>
                <ul class="submenu bg-gray-50 pr-8">
                    <li><a href="charge-wallet.php" class="block py-2 px-4 text-sm text-gray-700 hover:text-primary">شارژ کیف پول</a></li>
                    <li><a href="transactions.php" class="block py-2 px-4 text-sm text-gray-700 hover:text-primary">تاریخچه تراکنش‌ها</a></li>
                </ul>
            </li>
            <li>
                <a href="tickets.php" class="sidebar-item flex items-center px-4 py-3 text-gray-700 hover:text-primary <?= isUserPageActive('tickets.php'); ?>">
                    <div class="w-8 flex items-center justify-center ml-3"><i class="ri-customer-service-2-line ri-lg"></i></div>
                    <span>پشتیبانی</span>
                </a>
            </li>
            <?php if ($is_affiliate_system_enabled): ?>
                <li>
                    <a href="affiliate.php" class="sidebar-item flex items-center px-4 py-3 text-gray-700 hover:text-primary <?= isUserPageActive('affiliate.php'); ?>">
                        <div class="w-8 flex items-center justify-center ml-3"><i class="ri-share-line ri-lg"></i></div>
                        <span>همکاری در فروش</span>
                    </a>
                </li>
            <?php endif; ?>
        </ul>
    </nav>
</aside>