<?php
require_once '../core/config.php'; 
require_once '../core/database.php';
use App\MarzbanAPI;

if (!isset($_SESSION['user_id']) || !isset($_GET['order_id'])) {
    header("Location: my-services.php");
    exit();
}

$user_id = $_SESSION['user_id'];
$order_id = (int)$_GET['order_id'];

// دریافت اطلاعات سفارش و پلن مربوط به آن
$stmt = $pdo->prepare(
    "SELECT o.*, p.name as plan_name, p.price, p.duration_days, p.traffic_gb
     FROM orders o 
     JOIN plans p ON o.plan_id = p.id
     WHERE o.id = ? AND o.user_id = ? AND o.status != 'terminated'"
);
$stmt->execute([$order_id, $user_id]);
$order = $stmt->fetch(PDO::FETCH_ASSOC);

// اگر سفارش یافت نشد یا متعلق به این کاربر نبود
if (!$order) {
    header("Location: my-services.php");
    exit();
}

// پردازش فرم تمدید
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['confirm_renew'])) {
    // خواندن موجودی کیف پول کاربر
    $wallet_stmt = $pdo->prepare("SELECT wallet_balance FROM users WHERE id = ?");
    $wallet_stmt->execute([$user_id]);
    $wallet_balance = $wallet_stmt->fetchColumn();

    if ($wallet_balance >= $order['price']) {
        $api = new MarzbanAPI();
        // فراخوانی متد جدید برای تمدید
        $renew_response = $api->renewUser($order['marzban_username'], (int)$order['traffic_gb'], (int)$order['duration_days']);

        if (isset($renew_response['username'])) {
            // 1. کسر هزینه از کیف پول
            $new_balance = $wallet_balance - $order['price'];
            $pdo->prepare("UPDATE users SET wallet_balance = ? WHERE id = ?")->execute([$new_balance, $user_id]);

            // 2. آپدیت تاریخ انقضا و وضعیت سفارش در دیتابیس محلی
            $new_expiry_date = date('Y-m-d H:i:s', $renew_response['expire']);
            $pdo->prepare("UPDATE orders SET expiry_date = ?, status = 'active' WHERE id = ?")->execute([$new_expiry_date, $order_id]);

            $_SESSION['flash_message'] = "سرویس " . htmlspecialchars($order['marzban_username']) . " با موفقیت تمدید شد.";
            $_SESSION['flash_message_type'] = 'success';
            header("Location: my-services.php");
            exit();
        } else {
            $error_message = "خطا در تمدید سرویس: " . ($renew_response['error'] ?? 'پاسخ نامعتبر');
        }
    } else {
        $error_message = "موجودی کیف پول شما برای تمدید این سرویس کافی نیست.";
    }
}

include 'includes/header.php';
include 'includes/sidebar.php'; 
?>

<main id="main-content" class="flex-1 p-6 mr-64 transition-all duration-300">
    <div class="mb-8">
        <h1 class="text-2xl font-bold text-gray-800">تاییدیه تمدید سرویس</h1>
        <p class="text-gray-600 mt-1">لطفاً اطلاعات زیر را بررسی و در صورت تایید، عملیات را نهایی کنید.</p>
    </div>

    <?php if (isset($error_message)): ?>
        <div class="mb-4 p-4 rounded-lg bg-red-100 text-red-800"><?= htmlspecialchars($error_message) ?></div>
    <?php endif; ?>

    <div class="bg-white rounded-lg shadow-sm p-6 max-w-lg mx-auto">
        <div class="space-y-4 text-gray-700 border-b pb-4 mb-4">
            <div class="flex justify-between"><span>سرویس:</span> <strong class="font-mono"><?= htmlspecialchars($order['marzban_username']) ?></strong></div>
            <div class="flex justify-between"><span>پلن:</span> <strong><?= htmlspecialchars($order['plan_name']) ?></strong></div>
            <div class="flex justify-between"><span>تاریخ انقضای فعلی:</span> <strong class="text-red-600"><?= date("Y/m/d", strtotime($order['expiry_date'])) ?></strong></div>
        </div>
        <div class="space-y-4 text-gray-800">
            <div class="flex justify-between font-semibold"><span>هزینه تمدید:</span> <span><?= number_format($order['price']) ?> تومان</span></div>
            <div class="flex justify-between font-semibold"><span>موجودی کیف پول:</span> <span><?= number_format($wallet_balance ?? 0) ?> تومان</span></div>
        </div>

        <form action="renew-service.php?order_id=<?= $order_id ?>" method="POST" class="mt-6">
            <?php if (($wallet_balance ?? 0) >= $order['price']): ?>
                <button type="submit" name="confirm_renew" class="w-full bg-green-500 text-white py-3 rounded-lg font-semibold hover:bg-green-600">
                    تایید و تمدید سرویس
                </button>
            <?php else: ?>
                <div class="w-full bg-red-100 text-red-700 py-3 rounded-lg text-center">
                    موجودی کافی نیست! لطفاً ابتدا کیف پول خود را شارژ کنید.
                </div>
            <?php endif; ?>
            <a href="my-services.php" class="block text-center mt-3 text-sm text-gray-600 hover:text-primary">بازگشت به سرویس‌ها</a>
        </form>
    </div>
</main>

<?php include 'includes/footer.php'; ?>