<?php
require_once '../core/config.php'; 
require_once '../core/database.php';

if (!isset($_SESSION['user_id'])) {
    header("Location: ../login.php");
    exit();
}
$user_id = $_SESSION['user_id'];

// دریافت لیست تراکنش‌های این کاربر
$stmt = $pdo->prepare("SELECT * FROM transactions WHERE user_id = ? ORDER BY created_at DESC");
$stmt->execute([$user_id]);
$transactions = $stmt->fetchAll(PDO::FETCH_ASSOC);

// آرایه‌های کمکی برای نمایش نوع و وضعیت
$type_map = [ 'deposit' => 'شارژ کیف پول', 'purchase' => 'خرید سرویس', 'commission' => 'کمیسیون' ];
$status_map = [ 'completed' => ['text' => 'موفق', 'class' => 'bg-green-100 text-green-800'], 'pending' => ['text' => 'در انتظار', 'class' => 'bg-yellow-100 text-yellow-800'], 'failed' => ['text' => 'ناموفق', 'class' => 'bg-red-100 text-red-800'] ];

include 'includes/header.php';
include 'includes/sidebar.php'; 
?>
<main id="main-content" class="flex-1 p-6 mr-64 transition-all duration-300">
    <div class="mb-8">
        <h1 class="text-2xl font-bold text-gray-800">تاریخچه تراکنش‌ها</h1>
        <p class="text-gray-600 mt-1">لیست تمام فعالیت‌های مالی کیف پول شما.</p>
    </div>

    <div class="bg-white rounded-lg shadow-sm p-6">
        <div class="overflow-x-auto">
            <table class="w-full">
                <thead>
                    <tr class="border-b-2 border-gray-200">
                        <th class="text-right py-3 px-4 text-sm font-medium text-gray-500">نوع</th>
                        <th class="text-right py-3 px-4 text-sm font-medium text-gray-500">مبلغ (تومان)</th>
                        <th class="text-right py-3 px-4 text-sm font-medium text-gray-500">جزئیات</th>
                        <th class="text-right py-3 px-4 text-sm font-medium text-gray-500">تاریخ</th>
                        <th class="text-right py-3 px-4 text-sm font-medium text-gray-500">وضعیت</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (empty($transactions)): ?>
                        <tr><td colspan="5" class="text-center py-10 text-gray-500">هیچ تراکنشی یافت نشد.</td></tr>
                    <?php else: ?>
                        <?php foreach ($transactions as $tx): ?>
                            <tr class="border-b border-gray-100">
                                <td class="py-3 px-4 text-sm font-semibold"><?= htmlspecialchars($type_map[$tx['type']] ?? $tx['type']) ?></td>
                                <td class="py-3 px-4 text-sm font-mono 
                                    <?php 
                                        if (in_array($tx['type'], ['deposit', 'commission'])) echo 'text-green-600';
                                        else echo 'text-red-600';
                                    ?>">
                                    <?= (in_array($tx['type'], ['deposit', 'commission']) ? '+' : '-') . number_format($tx['amount']) ?>
                                </td>
                                <td class="py-3 px-4 text-sm text-gray-600"><?= htmlspecialchars($tx['description'] ?? '---') ?></td>
                                <td class="py-3 px-4 text-sm text-gray-500"><?= date("Y/m/d H:i", strtotime($tx['created_at'])) ?></td>
                                <td class="py-3 px-4 text-sm"><span class="px-2 py-1 text-xs rounded-full <?= $status_map[$tx['status']]['class'] ?? '' ?>"><?= $status_map[$tx['status']]['text'] ?? '' ?></span></td>
                            </tr>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</main>
<?php include 'includes/footer.php'; ?>