<?php 
require_once '../core/config.php'; 

// بررسی امنیتی دسترسی به پنل مدیریت
if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'admin') {
    header("Location: ../login.php");
    exit;
}
?>
<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= htmlspecialchars(setting('site_name', 'پنل مدیریت')) ?></title>
    <?php if(!empty(setting('site_favicon'))): ?>
        <link rel="icon" type="image/png" href="<?= BASE_URL . ltrim(setting('site_favicon'), '/') ?>">
    <?php endif; ?>
    
    <link href="https://cdnjs.cloudflare.com/ajax/libs/tailwindcss/2.2.19/tailwind.min.css" rel="stylesheet">
    
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Pacifico&display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Vazirmatn:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/remixicon/4.6.0/remixicon.min.css">
    <style>
        body { font-family: 'Vazirmatn', sans-serif; background-color: #f8fafc; }
        .sidebar-item.active { background-color: rgba(59, 130, 246, 0.1); border-right: 3px solid #3b82f6; }
        .sidebar-item:hover:not(.active) { background-color: rgba(59, 130, 246, 0.05); }
        .submenu { max-height: 0; overflow: hidden; transition: max-height 0.3s ease; }
        .submenu.open { max-height: 500px; }
        .submenu-toggle i.rotate-180 { transform: rotate(180deg); }
        .flex-c-c { display: flex; align-items: center; justify-content: center; }

        /* کلاس‌های سفارشی برای رنگ primary */
        .bg-primary { background-color: #3b82f6 !important; }
        .text-primary { color: #3b82f6 !important; }
        .border-primary { border-color: #3b82f6 !important; }
        .hover\:bg-primary\/90:hover { background-color: rgba(59, 130, 246, 0.9) !important; }
        .hover\:text-primary:hover { color: #3b82f6 !important; }
        .focus\:border-primary:focus { border-color: #3b82f6 !important; }
        .focus\:ring-primary\/50:focus { box-shadow: 0 0 0 3px rgba(59, 130, 246, 0.5) !important; }
    </style>
</head>
<body class="min-h-screen flex flex-col">
<header class="bg-white shadow-sm z-20 fixed w-full top-0">
    <div class="flex justify-between items-center px-6 py-3">
        <div class="flex items-center space-x-4 space-x-reverse">
            <button id="sidebar-toggle" class="w-10 h-10 flex items-center justify-center text-gray-500 hover:text-primary transition-colors">
                <i class="ri-menu-line ri-lg"></i>
            </button>
            <a href="dashboard.php" class="flex items-center">
                <?php if (!empty(setting('site_logo'))): ?>
                    <img src="<?= BASE_URL . ltrim(setting('site_logo'), '/') ?>" alt="<?= htmlspecialchars(setting('site_name')) ?>" class="h-8 w-auto">
                <?php else: ?>
                    <span class="text-xl font-['Pacifico'] text-primary"><?= htmlspecialchars(setting('site_logo_text', 'AIOConnect')) ?></span>
                <?php endif; ?>
            </a>
        </div>
        <div class="flex items-center space-x-4 space-x-reverse">
            <a href="tickets.php" title="تیکت‌های جدید">
                <button class="w-10 h-10 flex items-center justify-center text-gray-500 hover:text-primary transition-colors relative">
                    <i class="ri-notification-3-line ri-lg"></i>
                </button>
            </a>
            <div class="relative">
                <button id="user-menu-btn" class="flex items-center space-x-2 space-x-reverse text-gray-700 hover:text-primary transition-colors">
                    <span class="font-medium text-sm"><?= htmlspecialchars($_SESSION['username'] ?? 'مدیر'); ?></span>
                    <div class="w-8 h-8 bg-blue-100 rounded-full flex items-center justify-center text-primary">
                        <i class="ri-user-line"></i>
                    </div>
                </button>
                <div id="user-dropdown" class="absolute left-0 top-full mt-2 w-48 bg-white rounded-lg shadow-lg py-2 hidden z-20">
                    <a href="profile.php" class="block px-4 py-2 text-sm text-gray-700 hover:bg-blue-50 flex items-center"><i class="ri-user-settings-line ml-2"></i><span>پروفایل</span></a>
                    <a href="settings-general.php" class="block px-4 py-2 text-sm text-gray-700 hover:bg-blue-50 flex items-center"><i class="ri-settings-3-line ml-2"></i><span>تنظیمات</span></a>
                    <div class="border-t border-gray-100 my-1"></div>
                    <a href="../logout.php" class="block px-4 py-2 text-sm text-red-500 hover:bg-red-50 flex items-center"><i class="ri-logout-box-r-line ml-2"></i><span>خروج</span></a>
                </div>
            </div>
        </div>
    </div>
</header>
<div class="flex pt-16 flex-1">