<?php
require_once '../core/config.php';
require_once '../core/database.php';

if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'admin') {
    header("Location: ../login.php");
    exit();
}

$message = '';
$message_type = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $target_group = $_POST['target_group'];
    $specific_user = trim($_POST['specific_user']);
    $title = trim($_POST['title']);
    $notification_message = trim($_POST['message']);
    $link = trim($_POST['link']);

    if (empty($target_group) || empty($title) || empty($notification_message)) {
        $message = 'فیلدهای گروه هدف، عنوان و پیام الزامی هستند.';
        $message_type = 'error';
    } elseif ($target_group === 'specific' && empty($specific_user)) {
        $message = 'برای ارسال به کاربر خاص، باید نام کاربری او را وارد کنید.';
        $message_type = 'error';
    } else {
        try {
            $user_ids = [];
            switch ($target_group) {
                case 'all':
                    $stmt = $pdo->query("SELECT id FROM users");
                    $user_ids = $stmt->fetchAll(PDO::FETCH_COLUMN);
                    break;
                case 'resellers':
                    $stmt = $pdo->prepare("SELECT id FROM users WHERE role = ?");
                    $stmt->execute(['reseller']);
                    $user_ids = $stmt->fetchAll(PDO::FETCH_COLUMN);
                    break;
                case 'users':
                    $stmt = $pdo->prepare("SELECT id FROM users WHERE role = ?");
                    $stmt->execute(['user']);
                    $user_ids = $stmt->fetchAll(PDO::FETCH_COLUMN);
                    break;
                case 'specific':
                    $stmt = $pdo->prepare("SELECT id FROM users WHERE username = ?");
                    $stmt->execute([$specific_user]);
                    $user_id = $stmt->fetchColumn();
                    if ($user_id) {
                        $user_ids[] = $user_id;
                    } else {
                        throw new Exception("کاربری با نام کاربری '" . htmlspecialchars($specific_user) . "' یافت نشد.");
                    }
                    break;
            }

            if (!empty($user_ids)) {
                $pdo->beginTransaction();
                $insert_stmt = $pdo->prepare(
                    "INSERT INTO notifications (user_id, title, message, link) VALUES (?, ?, ?, ?)"
                );
                foreach ($user_ids as $uid) {
                    $insert_stmt->execute([$uid, $title, $notification_message, $link]);
                }
                $pdo->commit();
                $message = 'اعلان با موفقیت برای ' . count($user_ids) . ' کاربر ارسال شد.';
                $message_type = 'success';
            } else {
                if ($target_group !== 'specific') {
                   throw new Exception("هیچ کاربری در گروه هدف یافت نشد.");
                }
            }

        } catch (Exception $e) {
            if ($pdo->inTransaction()) {
                $pdo->rollBack();
            }
            $message = 'خطا: ' . $e->getMessage();
            $message_type = 'error';
        }
    }
}

include 'includes/header.php';
include 'includes/sidebar.php';
?>

<main id="main-content" class="flex-1 p-6 mr-64 transition-all duration-300">
    <div class="mb-8">
        <h1 class="text-2xl font-bold text-gray-800">ارسال اعلان دستی</h1>
        <p class="text-gray-600 mt-1">از این بخش می‌توانید برای کاربران خود اطلاعیه ارسال کنید.</p>
    </div>

    <?php if ($message): ?>
        <div class="mb-4 p-4 rounded-lg <?= $message_type === 'success' ? 'bg-green-100 text-green-800' : 'bg-red-100 text-red-800' ?>">
            <?= htmlspecialchars($message) ?>
        </div>
    <?php endif; ?>

    <div class="bg-white rounded-lg shadow-sm">
        <form action="send-notification.php" method="POST" class="p-6 space-y-6">
            <div>
                <label for="target_group" class="block text-sm font-medium text-gray-700 mb-1">ارسال به</label>
                <select name="target_group" id="target_group" class="mt-1 block w-full bg-white rounded-lg border border-gray-300 focus:border-primary focus:ring-1 focus:ring-primary/50 transition text-gray-900" required>
                    <option value="all">همه کاربران و نمایندگان</option>
                    <option value="resellers">فقط نمایندگان</option>
                    <option value="users">فقط کاربران عادی</option>
                    <option value="specific">یک کاربر خاص</option>
                </select>
            </div>

            <div id="specific_user_wrapper" class="hidden">
                <label for="specific_user" class="block text-sm font-medium text-gray-700 mb-1">نام کاربری کاربر خاص</label>
                <input type="text" name="specific_user" id="specific_user" class="mt-1 block w-full bg-white rounded-lg border border-gray-300 focus:border-primary focus:ring-1 focus:ring-primary/50 transition">
            </div>

            <div>
                <label for="title" class="block text-sm font-medium text-gray-700 mb-1">عنوان اعلان</label>
                <input type="text" name="title" id="title" class="mt-1 block w-full bg-white rounded-lg border border-gray-300 focus:border-primary focus:ring-1 focus:ring-primary/50 transition" required>
            </div>

            <div>
                <label for="message" class="block text-sm font-medium text-gray-700 mb-1">متن پیام</label>
                <textarea name="message" id="message" rows="5" class="mt-1 block w-full bg-white rounded-lg border border-gray-300 focus:border-primary focus:ring-1 focus:ring-primary/50 transition" required></textarea>
            </div>

            <div>
                <label for="link" class="block text-sm font-medium text-gray-700 mb-1">لینک (اختیاری)</label>
                <input type="text" name="link" id="link" placeholder="مثال: user/wallet.php" class="mt-1 block w-full bg-white rounded-lg border border-gray-300 focus:border-primary focus:ring-1 focus:ring-primary/50 transition text-left" style="direction: ltr;">
                <p class="text-xs text-gray-500 mt-1">کاربر با کلیک روی اعلان به این آدرس هدایت می‌شود. آدرس را نسبت به پنل کاربر/نماینده وارد کنید.</p>
            </div>

            <div class="pt-4 border-t flex justify-end">
                <button type="submit" class="bg-primary text-white px-6 py-2.5 rounded-lg hover:bg-primary/90">ارسال اعلان</button>
            </div>
        </form>
    </div>
</main>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const targetGroup = document.getElementById('target_group');
    const specificUserWrapper = document.getElementById('specific_user_wrapper');
    const specificUserInput = document.getElementById('specific_user');

    function toggleSpecificUserInput() {
        if (targetGroup.value === 'specific') {
            specificUserWrapper.classList.remove('hidden');
            specificUserInput.required = true;
        } else {
            specificUserWrapper.classList.add('hidden');
            specificUserInput.required = false;
        }
    }

    targetGroup.addEventListener('change', toggleSpecificUserInput);
    // اجرای اولیه در زمان بارگذاری صفحه
    toggleSpecificUserInput();
});
</script>

<?php include 'includes/footer.php'; ?>