<?php
require_once '../core/config.php';
require_once '../core/database.php';

// اگر سیستم همکاری در فروش غیرفعال بود، اجازه دسترسی نده
if(! (bool)setting('affiliate_system_enabled', 0)) {
    // می‌توانید به یک صفحه خطا هدایت کنید یا فقط پیام نمایش دهید
    die('سیستم همکاری در فروش غیرفعال است.');
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    try {
        $pdo->beginTransaction();
        $stmt = $pdo->prepare("UPDATE settings SET setting_value = ? WHERE setting_key = ?");
        
        $settings_to_save = [
            'affiliate_commission_tier1' => filter_input(INPUT_POST, 'tier1', FILTER_VALIDATE_INT, ['options' => ['min_range' => 0, 'max_range' => 100]]),
            'affiliate_commission_tier2' => filter_input(INPUT_POST, 'tier2', FILTER_VALIDATE_INT, ['options' => ['min_range' => 0, 'max_range' => 100]]),
            'affiliate_commission_tier3' => filter_input(INPUT_POST, 'tier3', FILTER_VALIDATE_INT, ['options' => ['min_range' => 0, 'max_range' => 100]]),
        ];

        foreach ($settings_to_save as $key => $value) {
            if ($value !== false) { // فقط اگر اعتبارسنجی موفق بود، ذخیره کن
                $stmt->execute([$value, $key]);
            }
        }

        $pdo->commit();
        $_SESSION['flash_message'] = 'تنظیمات با موفقیت ذخیره شد.';
        $_SESSION['flash_message_type'] = 'success';

    } catch (Exception $e) {
        $pdo->rollBack();
        $_SESSION['flash_message'] = 'خطا: ' . $e->getMessage();
        $_SESSION['flash_message_type'] = 'error';
    }
    header("Location: settings-affiliate.php");
    exit;
}

$settings = setting(null);
include 'includes/header.php';
include 'includes/sidebar.php';
?>
<main id="main-content" class="flex-1 p-6 mr-64 transition-all duration-300">
    <div class="mb-8">
        <h1 class="text-2xl font-bold text-gray-800">تنظیمات همکاری در فروش</h1>
        <p class="text-gray-600 mt-1">درصدهای کمیسیون برای سطوح مختلف خرید را اینجا تنظیم کنید.</p>
    </div>

    <?php if (isset($_SESSION['flash_message'])): /* ... کد نمایش پیام لحظه‌ای ... */ endif; ?>

    <div class="bg-white rounded-lg shadow-sm">
        <form action="settings-affiliate.php" method="POST">
            <div class="p-6 space-y-4">
                <div>
                    <label for="tier1" class="block text-sm font-medium text-gray-700">کمیسیون خرید اول (%)</label>
                    <input type="number" name="tier1" id="tier1" value="<?= htmlspecialchars($settings['affiliate_commission_tier1'] ?? '10') ?>" class="mt-1 w-full bg-gray-50 rounded-lg border-gray-300">
                </div>
                 <div>
                    <label for="tier2" class="block text-sm font-medium text-gray-700">کمیسیون خرید دوم (%)</label>
                    <input type="number" name="tier2" id="tier2" value="<?= htmlspecialchars($settings['affiliate_commission_tier2'] ?? '7') ?>" class="mt-1 w-full bg-gray-50 rounded-lg border-gray-300">
                </div>
                 <div>
                    <label for="tier3" class="block text-sm font-medium text-gray-700">کمیسیون خرید سوم به بعد (%)</label>
                    <input type="number" name="tier3" id="tier3" value="<?= htmlspecialchars($settings['affiliate_commission_tier3'] ?? '5') ?>" class="mt-1 w-full bg-gray-50 rounded-lg border-gray-300">
                </div>
            </div>
            <div class="p-6 bg-gray-50 flex justify-end">
                <button type="submit" class="bg-primary text-white px-6 py-2 rounded-lg hover:bg-primary/90">ذخیره تنظیمات</button>
            </div>
        </form>
    </div>
</main>
<?php include 'includes/footer.php'; ?>