<?php
require_once 'core/config.php';
require_once 'core/database.php';

if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit();
}

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    header("Location: user/wallet.php");
    exit();
}

$amount = filter_input(INPUT_POST, 'amount', FILTER_VALIDATE_INT);
$user_id = $_SESSION['user_id'];
$settings = setting(null);
$min_deposit = (int)($settings['min_deposit'] ?? 10000);
$max_deposit = (int)($settings['max_deposit'] ?? 1000000);

// اعتبارسنجی مبلغ
if ($amount === false || $amount < $min_deposit || $amount > $max_deposit) {
    $_SESSION['payment_error'] = "مبلغ وارد شده معتبر نیست. لطفاً مبلغی بین " . number_format($min_deposit) . " تا " . number_format($max_deposit) . " تومان وارد کنید.";
    header("Location: user/wallet.php");
    exit();
}

// 1. ثبت تراکنش اولیه در حالت 'pending'
$stmt = $pdo->prepare("INSERT INTO transactions (user_id, amount, status) VALUES (?, ?, 'pending')");
$stmt->execute([$user_id, $amount]);
$transaction_id = $pdo->lastInsertId();

// 2. آماده‌سازی اطلاعات برای ارسال به زرین‌پال
$merchant_id = $settings['zarinpal_merchant_id'] ?? '';
$is_sandbox = (bool)($settings['zarinpal_sandbox_enabled'] ?? true);
$callback_url = BASE_URL . 'payment-verify.php';
$description = "شارژ کیف پول برای سفارش شماره " . $transaction_id;

$data = [
    "merchant_id" => $merchant_id,
    "amount" => $amount * 10, // تبدیل تومان به ریال
    "callback_url" => $callback_url,
    "description" => $description,
];

// 3. ارسال درخواست به زرین‌پال
$jsonData = json_encode($data);
$ch = curl_init('https://api.zarinpal.com/pg/v4/payment/request.json');
if ($is_sandbox) {
    $ch = curl_init('https://sandbox.zarinpal.com/pg/v4/payment/request.json');
}

curl_setopt($ch, CURLOPT_USERAGENT, 'ZarinPal Rest Api v4');
curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'POST');
curl_setopt($ch, CURLOPT_POSTFIELDS, $jsonData);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    'Content-Type: application/json',
    'Content-Length: ' . strlen($jsonData)
]);

$result = curl_exec($ch);
$err = curl_error($ch);
curl_close($ch);
$result = json_decode($result, true, 512, JSON_BIGINT_AS_STRING);

// 4. پردازش پاسخ و هدایت کاربر
if ($err || empty($result['data']) || $result['data']['code'] != 100) {
    $error_code = $result['errors']['code'] ?? 'نامشخص';
    $_SESSION['payment_error'] = "خطا در اتصال به درگاه پرداخت. کد خطا: " . $error_code;
    header("Location: user/wallet.php");
    exit();
} else {
    // ذخیره کد Authority برای پیگیری تراکنش
    $authority = $result['data']["authority"];
    $pdo->prepare("UPDATE transactions SET authority = ? WHERE id = ?")->execute([$authority, $transaction_id]);
    
    // هدایت کاربر به صفحه پرداخت
    $payment_url = 'https://www.zarinpal.com/pg/StartPay/' . $authority;
    if ($is_sandbox) {
        $payment_url = 'https://sandbox.zarinpal.com/pg/StartPay/' . $authority;
    }
    header('Location: ' . $payment_url);
    exit();
}