<?php
require_once 'core/config.php';
require_once 'core/database.php';

// ۱. دریافت پارامترها از زرین‌پال
if (empty($_GET['Authority']) || empty($_GET['Status'])) {
    // اگر پارامترها وجود نداشتند، کاربر را به پنل خودش بازگردان
    $redirect_page = (($_SESSION['role'] ?? 'user') === 'reseller') ? 'reseller/wallet.php' : 'user/wallet.php';
    header("Location: " . $redirect_page);
    exit;
}

$authority = $_GET['Authority'];
$status = $_GET['Status'];

// ۲. پیدا کردن تراکنش در دیتابیس ما
$stmt = $pdo->prepare("SELECT * FROM transactions WHERE authority = ? AND status = 'pending'");
$stmt->execute([$authority]);
$transaction = $stmt->fetch(PDO::FETCH_ASSOC);

// اگر تراکنشی با این مشخصات یافت نشد یا قبلا پردازش شده بود
if (!$transaction) {
    $_SESSION['payment_error'] = "تراکنش نامعتبر یا تکراری است.";
    $redirect_page = (($_SESSION['role'] ?? 'user') === 'reseller') ? 'reseller/wallet.php' : 'user/wallet.php';
    header("Location: " . $redirect_page);
    exit;
}

$user_id = $transaction['user_id'];
$amount = (int)$transaction['amount']; // مبلغ به تومان

// پیدا کردن پنل کاربر (عادی یا نماینده) برای بازگشت صحیح
$role_stmt = $pdo->prepare("SELECT role FROM users WHERE id = ?");
$role_stmt->execute([$user_id]);
$user_role = $role_stmt->fetchColumn();
$wallet_page_url = ($user_role === 'reseller') ? 'reseller/wallet.php' : 'user/wallet.php';


// اگر کاربر پرداخت را لغو کرده بود
if ($status !== 'OK') {
    $pdo->prepare("UPDATE transactions SET status = 'failed' WHERE id = ?")->execute([$transaction['id']]);
    $_SESSION['payment_error'] = "پرداخت توسط شما لغو شد.";
    header("Location: " . $wallet_page_url);
    exit;
}

// ۳. تایید نهایی تراکنش با سرور زرین‌پال (مهم‌ترین بخش امنیتی)
$merchant_id = setting('zarinpal_merchant_id');
$is_sandbox = (bool)setting('zarinpal_sandbox_enabled', true);

$data = ["merchant_id" => $merchant_id, "authority" => $authority, "amount" => $amount * 10]; // مبلغ به ریال
$jsonData = json_encode($data);

$ch = curl_init('https://api.zarinpal.com/pg/v4/payment/verify.json');
if ($is_sandbox) {
    $ch = curl_init('https://sandbox.zarinpal.com/pg/v4/payment/verify.json');
}

curl_setopt($ch, CURLOPT_USERAGENT, 'ZarinPal Rest Api v4');
curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'POST');
curl_setopt($ch, CURLOPT_POSTFIELDS, $jsonData);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json', 'Content-Length: ' . strlen($jsonData)]);

$result = curl_exec($ch);
curl_close($ch);
$result = json_decode($result, true);

// ۴. پردازش پاسخ نهایی و شارژ کیف پول
if (!empty($result['data']) && ($result['data']['code'] == 100 || $result['data']['code'] == 101)) {
    // تراکنش موفق و تایید شده است
    $ref_id = $result['data']['ref_id'];
    
    // آپدیت جدول تراکنش
    $pdo->prepare("UPDATE transactions SET status = 'completed', ref_id = ? WHERE id = ?")->execute([$ref_id, $transaction['id']]);
        
    // افزایش موجودی کیف پول کاربر
    $pdo->prepare("UPDATE users SET wallet_balance = wallet_balance + ? WHERE id = ?")->execute([$amount, $user_id]);

    $_SESSION['flash_message'] = "پرداخت موفقیت آمیز بود. مبلغ " . number_format($amount) . " تومان به کیف پول شما اضافه شد.";
    $_SESSION['flash_message_type'] = 'success';
} else {
    // تراکنش ناموفق بود
    $error_code = $result['errors']['code'] ?? 'نامشخص';
    $pdo->prepare("UPDATE transactions SET status = 'failed' WHERE id = ?")->execute([$transaction['id']]);
    $_SESSION['payment_error'] = "تایید تراکنش ناموفق بود. کد خطا: " . $error_code;
}

// در هر صورت کاربر را به صفحه کیف پول خودش هدایت کن
header("Location: " . $wallet_page_url);
exit;