<?php
require_once 'core/config.php';
require_once 'core/database.php';

// اگر کاربر لاگین کرده، به پنلش هدایت شود
if (isset($_SESSION['user_id'])) { header("Location: index.php"); exit(); }

$referral_code = trim($_GET['ref'] ?? '');

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = trim($_POST['username']);
    $email = trim($_POST['email']);
    $password = $_POST['password'];
    $confirm_password = $_POST['confirm_password'];
    $posted_ref_code = trim($_POST['referral_code']);

    if (empty($username) || empty($email) || empty($password)) {
        $error_message = 'تمام فیلدها الزامی هستند.';
    } elseif ($password !== $confirm_password) {
        $error_message = 'رمز عبور و تکرار آن یکسان نیستند.';
    } else {
        // بررسی تکراری نبودن نام کاربری یا ایمیل
        $stmt = $pdo->prepare("SELECT id FROM users WHERE username = ? OR email = ?");
        $stmt->execute([$username, $email]);
        if ($stmt->fetch()) {
            $error_message = 'نام کاربری یا ایمیل قبلا در سیستم ثبت شده است.';
        } else {
            $referred_by_id = null;
            if (!empty($posted_ref_code)) {
                $ref_stmt = $pdo->prepare("SELECT id FROM users WHERE referral_code = ?");
                $ref_stmt->execute([$posted_ref_code]);
                $referrer = $ref_stmt->fetch();
                if ($referrer) {
                    $referred_by_id = $referrer['id'];
                }
            }

            // ساخت کاربر جدید
            do {
                $new_referral_code = substr(str_shuffle('0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ'), 0, 8);
                $check_code_stmt = $pdo->prepare("SELECT id FROM users WHERE referral_code = ?");
                $check_code_stmt->execute([$new_referral_code]);
            } while ($check_code_stmt->fetch());

            $hashed_password = password_hash($password, PASSWORD_DEFAULT);
            $insert_stmt = $pdo->prepare("INSERT INTO users (username, email, password, role, referred_by, referral_code) VALUES (?, ?, ?, 'user', ?, ?)");
            $insert_stmt->execute([$username, $email, $hashed_password, $referred_by_id, $new_referral_code]);
            
            // لاگین خودکار کاربر پس از ثبت نام
            $_SESSION['user_id'] = $pdo->lastInsertId();
            $_SESSION['username'] = $username;
            $_SESSION['role'] = 'user';
            header("Location: index.php");
            exit();
        }
    }
}
?>
<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <title>ثبت نام در <?= htmlspecialchars(setting('site_name')) ?></title>
    </head>
<body class="flex items-center justify-center min-h-screen bg-gray-50">
    <div class="w-full max-w-md bg-white rounded-lg shadow-md p-8">
        <h1 class="text-2xl font-bold text-center text-gray-800 mb-6">ایجاد حساب کاربری جدید</h1>
        <?php if(isset($error_message)): ?>
            <div class="bg-red-100 border-l-4 border-red-500 text-red-700 p-4 mb-4" role="alert"><p><?= $error_message ?></p></div>
        <?php endif; ?>
        <form action="register.php" method="POST">
            <input type="hidden" name="referral_code" value="<?= htmlspecialchars($referral_code) ?>">
            <div class="mb-4">
                <label for="username" class="block text-gray-700 text-sm font-bold mb-2">نام کاربری</label>
                <input type="text" name="username" class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700" required>
            </div>
            <div class="mb-4">
                <label for="email" class="block text-gray-700 text-sm font-bold mb-2">ایمیل</label>
                <input type="email" name="email" class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700" required>
            </div>
            <div class="mb-4">
                <label for="password" class="block text-gray-700 text-sm font-bold mb-2">رمز عبور</label>
                <input type="password" name="password" class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700" required>
            </div>
            <div class="mb-6">
                <label for="confirm_password" class="block text-gray-700 text-sm font-bold mb-2">تکرار رمز عبور</label>
                <input type="password" name="confirm_password" class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700">
            </div>
            <?php if(!empty($referral_code)): ?>
                <div class="bg-green-100 text-green-800 p-3 rounded text-center mb-4">شما توسط یک دوست دعوت شده‌اید!</div>
            <?php endif; ?>
            <button type="submit" class="bg-blue-500 hover:bg-blue-700 text-white font-bold py-2 px-4 rounded w-full">ثبت نام</button>
            <p class="text-center text-sm text-gray-600 mt-4">حساب کاربری دارید؟ <a href="login.php" class="text-blue-500 hover:underline">وارد شوید</a></p>
        </form>
    </div>
</body>
</html>