<?php
require_once '../core/config.php'; 
require_once '../core/database.php';

if (!isset($_SESSION['user_id'])) { header("Location: ../login.php"); exit(); }

if(!(bool)setting('affiliate_system_enabled', 0)) { die('سیستم همکاری در فروش غیرفعال است.'); }

$user_id = $_SESSION['user_id'];

// دریافت اطلاعات همکاری در فروش کاربر
$stmt = $pdo->prepare("SELECT referral_code FROM users WHERE id = ?");
$stmt->execute([$user_id]);
$user_data = $stmt->fetch(PDO::FETCH_ASSOC);

// --- بخش جدید: تولید کد معرف در صورت عدم وجود ---
if (empty($user_data['referral_code'])) {
    do {
        $new_referral_code = substr(str_shuffle('0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ'), 0, 8);
        $check_code_stmt = $pdo->prepare("SELECT id FROM users WHERE referral_code = ?");
        $check_code_stmt->execute([$new_referral_code]);
    } while ($check_code_stmt->fetch());

    // ذخیره کد جدید در دیتابیس
    $update_stmt = $pdo->prepare("UPDATE users SET referral_code = ? WHERE id = ?");
    $update_stmt->execute([$new_referral_code, $user_id]);
    
    // استفاده از کد جدید در ادامه اسکریپت
    $user_data['referral_code'] = $new_referral_code;
}

$referral_link = BASE_URL . 'register.php?ref=' . $user_data['referral_code'];

// شمارش تعداد کاربران معرفی شده
$referred_users_count = $pdo->prepare("SELECT COUNT(*) FROM users WHERE referred_by = ?");
$referred_users_count->execute([$user_id]);
$total_referred = $referred_users_count->fetchColumn();

include 'includes/header.php';
include 'includes/sidebar.php'; 
?>
<main id="main-content" class="flex-1 p-6 mr-64 transition-all duration-300">
    <div class="mb-8">
        <h1 class="text-2xl font-bold text-gray-800">همکاری در فروش</h1>
        <p class="text-gray-600 mt-1">با معرفی دوستان خود، کسب درآمد کنید!</p>
    </div>
    <div class="bg-white rounded-lg shadow-sm p-6">
        <h3 class="text-lg font-semibold text-gray-800">لینک دعوت اختصاصی شما</h3>
        <p class="text-sm text-gray-500 mt-2">این لینک را با دوستان خود به اشتراک بگذارید. هر کاربری که با این لینک ثبت‌نام کند، به عنوان زیرمجموعه شما شناخته خواهد شد.</p>
        <div class="relative mt-4">
            <input type="text" readonly value="<?= htmlspecialchars($referral_link) ?>" class="w-full bg-gray-100 rounded-lg p-3 text-gray-600 font-mono pr-10 cursor-pointer text-left" onclick="this.select(); document.execCommand('copy'); alert('لینک کپی شد!');">
            <i class="ri-clipboard-line absolute top-1/2 right-3 transform -translate-y-1/2 text-gray-400"></i>
        </div>
        <hr class="my-6">
        <h3 class="text-lg font-semibold text-gray-800">آمار شما</h3>
        <div class="grid grid-cols-2 gap-4 mt-4">
            <div class="bg-blue-50 p-4 rounded-lg text-center">
                <p class="text-sm text-blue-800">تعداد زیرمجموعه‌ها</p>
                <p class="text-2xl font-bold text-blue-900 mt-1"><?= number_format($total_referred) ?></p>
            </div>
             <div class="bg-green-50 p-4 rounded-lg text-center">
                <p class="text-sm text-green-800">درآمد کل (تومان)</p>
                <p class="text-2xl font-bold text-green-900 mt-1">۰</p>
            </div>
        </div>
    </div>
</main>
<?php include 'includes/footer.php'; ?>