<?php
require_once '../core/config.php'; 
require_once '../core/database.php';

if (!isset($_SESSION['user_id'])) {
    header("Location: ../login.php");
    exit();
}
$user_id = $_SESSION['user_id'];
$message = '';
$message_type = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // استفاده از trim برای حذف فاصله‌های اضافی احتمالی
    $telegram_chat_id = trim($_POST['telegram_chat_id']);
    
    if (!empty($telegram_chat_id) && !is_numeric($telegram_chat_id)) {
        $message = 'شناسه چت تلگرام باید فقط شامل اعداد باشد.';
        $message_type = 'error';
    } else {
        try {
            $pdo->beginTransaction();
            
            $params = [];
            $sql = "UPDATE users SET telegram_chat_id = ?";
            $params[] = $telegram_chat_id;

            if (!empty($_POST['new_password'])) {
                if (empty($_POST['current_password'])) {
                    throw new Exception('برای تغییر رمز عبور، باید رمز فعلی خود را وارد کنید.');
                }
                if ($_POST['new_password'] !== $_POST['confirm_password']) {
                    throw new Exception('رمز عبور جدید و تکرار آن یکسان نیستند.');
                }
                if (strlen($_POST['new_password']) < 6) {
                    throw new Exception('رمز عبور جدید باید حداقل ۶ کاراکتر باشد.');
                }
                
                $user_stmt = $pdo->prepare("SELECT password FROM users WHERE id = ?");
                $user_stmt->execute([$user_id]);
                $current_password_hash = $user_stmt->fetchColumn();

                if (!password_verify($_POST['current_password'], $current_password_hash)) {
                    throw new Exception('رمز عبور فعلی شما صحیح نمی‌باشد.');
                }

                $sql .= ", password = ?";
                $params[] = password_hash($_POST['new_password'], PASSWORD_DEFAULT);
            }
            
            $sql .= " WHERE id = ?";
            $params[] = $user_id;
            
            $update_stmt = $pdo->prepare($sql);
            $update_stmt->execute($params);

            $pdo->commit();

            $_SESSION['flash_message'] = 'پروفایل شما با موفقیت بروزرسانی شد.';
            $_SESSION['flash_message_type'] = 'success';
            header("Location: profile.php");
            exit;

        } catch (Exception $e) {
            if ($pdo->inTransaction()) {
                $pdo->rollBack();
            }
            $message = 'خطا: ' . $e->getMessage();
            $message_type = 'error';
        }
    }
}

// خواندن اطلاعات کاربر برای نمایش در فرم
$stmt = $pdo->prepare("SELECT username, telegram_chat_id FROM users WHERE id = ?");
$stmt->execute([$user_id]);
$user = $stmt->fetch(PDO::FETCH_ASSOC);

// خواندن پیام‌های لحظه‌ای پس از ریدایرکت
if (isset($_SESSION['flash_message'])) {
    $message = $_SESSION['flash_message'];
    $message_type = $_SESSION['flash_message_type'] ?? 'success';
    unset($_SESSION['flash_message'], $_SESSION['flash_message_type']);
}

include 'includes/header.php';
include 'includes/sidebar.php'; 
?>

<main id="main-content" class="flex-1 p-6 mr-64 transition-all duration-300">
    <div class="mb-8">
        <h1 class="text-2xl font-bold text-gray-800">پروفایل کاربری</h1>
    </div>

    <?php if ($message): ?>
        <div class="mb-4 p-4 rounded-lg <?= $message_type === 'success' ? 'bg-green-100 text-green-800' : 'bg-red-100 text-red-800' ?>">
            <?= htmlspecialchars($message) ?>
        </div>
    <?php endif; ?>

    <div class="bg-white rounded-lg shadow-sm p-6 max-w-lg mx-auto">
        <form action="profile.php" method="POST">
            <div class="space-y-6">
                <div>
                    <label for="telegram_chat_id" class="block text-sm font-medium text-gray-700">شناسه چت تلگرام</label>
                    <input type="text" name="telegram_chat_id" id="telegram_chat_id" value="<?= htmlspecialchars($user['telegram_chat_id'] ?? '') ?>" class="mt-1 w-full bg-white rounded-lg border border-gray-300 text-left" style="direction: ltr;">
                    <p class="text-xs text-gray-500 mt-1">برای اتصال به ربات، شناسه خود را از <a href="https://t.me/userinfobot" target="_blank" class="text-primary hover:underline">@userinfobot</a> دریافت و اینجا وارد کنید.</p>
                </div>
                <hr>
                <div>
                    <h3 class="text-md font-semibold text-gray-800">تغییر رمز عبور</h3>
                    <p class="text-xs text-gray-500 mt-1">اگر قصد تغییر رمز را ندارید، این فیلدها را خالی بگذارید.</p>
                    <div class="space-y-4 mt-4">
                         <div>
                            <label for="current_password" class="block text-sm font-medium text-gray-700">رمز عبور فعلی</label>
                            <input type="password" name="current_password" class="mt-1 w-full bg-white rounded-lg border border-gray-300">
                        </div>
                        <div>
                            <label for="new_password" class="block text-sm font-medium text-gray-700">رمز عبور جدید</label>
                            <input type="password" name="new_password" class="mt-1 w-full bg-white rounded-lg border border-gray-300">
                        </div>
                        <div>
                            <label for="confirm_password" class="block text-sm font-medium text-gray-700">تکرار رمز عبور جدید</label>
                            <input type="password" name="confirm_password" class="mt-1 w-full bg-white rounded-lg border border-gray-300">
                        </div>
                    </div>
                </div>
            </div>
            <div class="mt-6">
                <button type="submit" class="w-full bg-primary text-white py-2.5 rounded-lg font-semibold hover:bg-primary/90">
                    ذخیره تغییرات
                </button>
            </div>
        </form>
    </div>
</main>
<?php include 'includes/footer.php'; ?>