<?php
require_once '../core/config.php';
require_once '../core/database.php';

if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'reseller') {
    header("Location: ../login.php");
    exit();
}
$reseller_id = $_SESSION['user_id'];

$message = '';
$message_type = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $action_message = '';
    try {
        // پردازش فرم پیشوند
        if (isset($_POST['save_prefix'])) {
            $prefix = trim($_POST['user_prefix']);
            if (empty($prefix) || !preg_match('/^[a-zA-Z0-9_]+$/', $prefix) || strlen($prefix) > 15) {
                throw new Exception('پیشوند نامعتبر است. فقط از حروف و اعداد انگلیسی و آندرلاین (حداکثر ۱۵ کاراکتر) استفاده کنید.');
            }
            $check_stmt = $pdo->prepare("SELECT id FROM users WHERE user_prefix = ? AND id != ?");
            $check_stmt->execute([$prefix, $reseller_id]);
            if ($check_stmt->fetch()) {
                throw new Exception('این پیشوند قبلا توسط نماینده دیگری انتخاب شده است.');
            }
            $stmt = $pdo->prepare("UPDATE users SET user_prefix = ? WHERE id = ?");
            $stmt->execute([$prefix, $reseller_id]);
            $action_message = 'پیشوند با موفقیت ذخیره شد.';
        }
        
        // پردازش فرم توکن ربات
        if (isset($_POST['save_bot_token'])) {
            $bot_token = trim($_POST['bot_token']);
            $stmt = $pdo->prepare("UPDATE users SET telegram_bot_token = ? WHERE id = ?");
            $stmt->execute([$bot_token, $reseller_id]);
            $action_message = 'توکن ربات تلگرام با موفقیت ذخیره شد.';
        }
        
        $_SESSION['flash_message'] = $action_message;
        $_SESSION['flash_message_type'] = 'success';
    } catch (Exception $e) {
        $_SESSION['flash_message'] = 'خطا: ' . $e->getMessage();
        $_SESSION['flash_message_type'] = 'error';
    }
    header("Location: settings.php");
    exit;
}


if (isset($_SESSION['flash_message'])) {
    $message = $_SESSION['flash_message'];
    $message_type = $_SESSION['flash_message_type'] ?? 'success';
    unset($_SESSION['flash_message'], $_SESSION['flash_message_type']);
}

// خواندن اطلاعات فعلی نماینده
$stmt = $pdo->prepare("SELECT user_prefix, telegram_bot_token FROM users WHERE id = ?");
$stmt->execute([$reseller_id]);
$reseller = $stmt->fetch(PDO::FETCH_ASSOC);

include 'includes/header.php';
include 'includes/sidebar.php';
?>

<main id="main-content" class="flex-1 p-6 mr-64 transition-all duration-300">
    <div class="mb-8">
        <h1 class="text-2xl font-bold text-gray-800">تنظیمات نماینده</h1>
        <p class="text-gray-600 mt-1">تنظیمات اختصاصی پنل نمایندگی خود را در اینجا مدیریت کنید.</p>
    </div>

    <?php if ($message): ?>
        <div class="mb-4 p-4 rounded-lg <?= $message_type === 'success' ? 'bg-green-100 text-green-800' : 'bg-red-100 text-red-800' ?>">
            <?= htmlspecialchars($message) ?>
        </div>
    <?php endif; ?>

    <div class="bg-white rounded-lg shadow-sm">
        <form action="settings.php" method="POST">
            <div class="p-6">
                 <h3 class="text-lg font-semibold text-gray-800 border-b pb-3">پیشوند نام کاربری</h3>
                <p class="mt-2 text-xs text-gray-500">این پیشوند به ابتدای نام کاربری تمام مشتریان شما اضافه خواهد شد.</p>
                <div class="mt-4">
                    <label for="user_prefix" class="block text-sm font-medium text-gray-700">پیشوند دلخواه</label>
                    <input type="text" name="user_prefix" id="user_prefix" 
                           value="<?= htmlspecialchars($reseller['user_prefix'] ?? '') ?>" 
                           class="mt-1 block w-full bg-white rounded-lg border border-gray-300 focus:border-primary focus:ring-1 focus:ring-primary/50 transition"
                           placeholder="مثال: myprefix_">
                </div>
            </div>
            <div class="p-6 bg-gray-50 flex justify-end">
                <button type="submit" name="save_prefix" class="bg-primary text-white px-6 py-2 rounded-lg hover:bg-primary/90">ذخیره پیشوند</button>
            </div>
        </form>
    </div>

    <div class="bg-white rounded-lg shadow-sm mt-8">
        <form action="settings.php" method="POST">
            <div class="p-6">
                <h3 class="text-lg font-semibold text-gray-800 border-b pb-3">تنظیمات ربات تلگرام</h3>
                <p class="text-sm text-gray-500 mt-2">
                    برای فعال‌سازی ربات، یک ربات جدید در تلگرام از طریق <a href="https://t.me/BotFather" target="_blank" class="text-primary hover:underline">@BotFather</a> بسازید و توکن API آن را در فیلد زیر وارد کنید.
                </p>
                <div class="mt-4">
                    <label for="bot_token" class="block text-sm font-medium text-gray-700">توکن API ربات تلگرام</label>
                    <input type="text" name="bot_token" id="bot_token" 
                           value="<?= htmlspecialchars($reseller['telegram_bot_token'] ?? '') ?>" 
                           class="mt-1 block w-full bg-white rounded-lg border border-gray-300 focus:border-primary focus:ring-1 focus:ring-primary/50 transition text-left" 
                           style="direction: ltr;"
                           placeholder="مثال: 123456:ABC-DEF1234ghIkl-zyx57W2v1u123ew11">
                </div>
            </div>
            <div class="p-6 bg-gray-50 flex justify-end">
                <button type="submit" name="save_bot_token" class="bg-primary text-white px-6 py-2 rounded-lg hover:bg-primary/90">ذخیره توکن</button>
            </div>
        </form>
    </div>
</main>

<?php include 'includes/footer.php'; ?>