<?php
require_once '../core/config.php';
require_once '../core/database.php';

// اطمینان از اینکه کاربر لاگین کرده و نقش او "reseller" است
if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'reseller') {
    header("Location: ../login.php");
    exit();
}
$reseller_id = $_SESSION['user_id'];

$message = '';
$message_type = '';
$edit_user_data = null; // برای داده‌های ویرایش در آینده

// پردازش فرم افزودن کاربر جدید توسط نماینده
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['add_user'])) {
    $username = trim($_POST['username']);
    $password = $_POST['password'];

    if (empty($username) || empty($password)) {
        $message = 'نام کاربری و رمز عبور الزامی است.';
        $message_type = 'error';
    } else {
        try {
            // تولید کد معرف منحصر به فرد
            do {
                $referral_code = substr(str_shuffle('0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ'), 0, 8);
                $check_code_stmt = $pdo->prepare("SELECT id FROM users WHERE referral_code = ?");
                $check_code_stmt->execute([$referral_code]);
            } while ($check_code_stmt->fetch());

            $hashed_password = password_hash($password, PASSWORD_DEFAULT);
            $stmt = $pdo->prepare(
                "INSERT INTO users (username, password, role, reseller_id, referral_code) VALUES (?, ?, 'user', ?, ?)"
            );
            $stmt->execute([$username, $hashed_password, $reseller_id, $referral_code]);
            $message = 'کاربر جدید با موفقیت توسط شما اضافه شد.';
            $message_type = 'success';
        } catch (PDOException $e) {
            if ($e->errorInfo[1] == 1062) {
                $message = 'خطا: این نام کاربری قبلا در سیستم ثبت شده است.';
            } else {
                $message = 'خطا در ذخیره سازی کاربر.';
            }
            $message_type = 'error';
        }
    }
}

// دریافت لیست کاربرانی که فقط توسط این نماینده ساخته شده‌اند
$stmt = $pdo->prepare("SELECT id, username, created_at FROM users WHERE reseller_id = ? ORDER BY created_at DESC");
$stmt->execute([$reseller_id]);
$users_list = $stmt->fetchAll(PDO::FETCH_ASSOC);

include 'includes/header.php';
include 'includes/sidebar.php';
?>

<main id="main-content" class="flex-1 p-6 mr-64 transition-all duration-300">
    <div class="flex justify-between items-center mb-6">
        <h1 class="text-2xl font-bold text-gray-800">مدیریت کاربران شما</h1>
        <button id="add-user-btn" class="bg-primary text-white px-5 py-2 rounded-lg hover:bg-primary/90 transition-colors flex items-center space-x-2 space-x-reverse">
            <i class="ri-add-line"></i>
            <span>افزودن کاربر جدید</span>
        </button>
    </div>

    <?php if ($message): ?>
        <div class="mb-4 p-4 rounded-lg <?= $message_type === 'success' ? 'bg-green-100 text-green-800' : 'bg-red-100 text-red-800' ?>"><?= htmlspecialchars($message) ?></div>
    <?php endif; ?>

    <div class="bg-white rounded-lg shadow-sm p-6">
        <div class="overflow-x-auto">
            <table class="w-full">
                <thead>
                    <tr class="border-b-2 border-gray-200">
                        <th class="text-right py-3 px-4 text-sm font-medium text-gray-500">نام کاربری</th>
                        <th class="text-right py-3 px-4 text-sm font-medium text-gray-500">تاریخ ثبت</th>
                        <th class="text-center py-3 px-4 text-sm font-medium text-gray-500">عملیات</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (empty($users_list)): ?>
                        <tr><td colspan="3" class="text-center py-6 text-gray-500">شما هنوز هیچ کاربری نساخته‌اید.</td></tr>
                    <?php else: ?>
                        <?php foreach ($users_list as $user): ?>
                            <tr class="border-b border-gray-100 hover:bg-gray-50">
                                <td class="py-3 px-4 font-semibold"><?= htmlspecialchars($user['username']) ?></td>
                                <td class="py-3 px-4 text-gray-500"><?= date("Y/m/d", strtotime($user['created_at'])) ?></td>
                                <td class="py-3 px-4 text-center">
                                    <button title="در آینده اضافه خواهد شد" class="text-gray-300 cursor-not-allowed"><i class="ri-pencil-line ri-lg"></i></button>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</main>

<div id="user-modal" class="hidden fixed inset-0 bg-black bg-opacity-60 flex items-center justify-center z-50 p-4">
    <div class="bg-white rounded-lg shadow-xl p-6 w-full max-w-sm">
        <div class="flex justify-between items-center border-b pb-3 mb-4">
            <h2 class="text-xl font-bold">افزودن کاربر جدید</h2>
            <button id="close-modal-btn" class="text-gray-500 hover:text-gray-800"><i class="ri-close-line ri-lg"></i></button>
        </div>
        <form action="users.php" method="POST">
            <div class="space-y-4">
                <div>
                    <label for="username" class="block text-sm font-medium text-gray-700 mb-1">نام کاربری</label>
                    <input type="text" name="username" class="w-full bg-white rounded-lg border border-gray-300 focus:border-primary focus:ring-1 focus:ring-primary/50 transition" required>
                </div>
                <div>
                    <label for="password" class="block text-sm font-medium text-gray-700 mb-1">رمز عبور</label>
                    <input type="password" name="password" class="w-full bg-white rounded-lg border border-gray-300 focus:border-primary focus:ring-1 focus:ring-primary/50 transition" required>
                </div>
            </div>
            <div class="mt-6 flex justify-end space-x-2 space-x-reverse">
                <button type="button" id="cancel-btn" class="bg-gray-200 px-4 py-2 rounded-lg hover:bg-gray-300">لغو</button>
                <button type="submit" name="add_user" class="bg-primary text-white px-4 py-2 rounded-lg hover:bg-primary/90">افزودن</button>
            </div>
        </form>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const modal = document.getElementById('user-modal');
    const addUserBtn = document.getElementById('add-user-btn');
    const closeModalBtn = document.getElementById('close-modal-btn');
    const cancelBtn = document.getElementById('cancel-btn');

    addUserBtn.addEventListener('click', () => modal.classList.remove('hidden'));
    closeModalBtn.addEventListener('click', () => modal.classList.add('hidden'));
    cancelBtn.addEventListener('click', () => modal.classList.add('hidden'));
    
    modal.addEventListener('click', (e) => {
        if (e.target === modal) {
            modal.classList.add('hidden');
        }
    });
});
</script>

<?php include 'includes/footer.php'; ?>