<?php
require_once '../core/config.php';
require_once '../core/database.php';
use App\MarzbanAPI;

header('Content-Type: application/json');

// بررسی لاگین بودن کاربر
if (!isset($_SESSION['user_id'])) {
    echo json_encode(['error' => 'دسترسی غیرمجاز']);
    exit;
}

$marzban_username = $_GET['username'] ?? '';
if (empty($marzban_username)) {
    echo json_encode(['error' => 'نام کاربری سرویس مشخص نشده است.']);
    exit;
}

// بررسی امنیتی: آیا این سرویس متعلق به کاربر لاگین کرده است؟
$stmt = $pdo->prepare("SELECT * FROM orders WHERE marzban_username = ? AND user_id = ?");
$stmt->execute([$marzban_username, $_SESSION['user_id']]);
$order = $stmt->fetch();

if (!$order) {
    echo json_encode(['error' => 'این سرویس متعلق به شما نیست.']);
    exit;
}

$api = new MarzbanAPI();
$marzban_user = $api->getUser($marzban_username);

if (isset($marzban_user['error'])) {
    echo json_encode(['error' => 'خطا در دریافت اطلاعات از سرور: ' . $marzban_user['error']]);
    exit;
}

$subscription_url = $marzban_user['subscription_url'] ?? '';
if (empty($subscription_url)) {
    echo json_encode(['error' => 'لینک اشتراکی برای این کاربر یافت نشد.']);
    exit;
}

$configs_result = $api->getConfigsFromSubscription($subscription_url);

if (isset($configs_result['error'])) {
     echo json_encode(['error' => 'خطا در خواندن لینک اشتراک: ' . $configs_result['error']]);
    exit;
}

// محاسبه اطلاعات مصرف و روزهای باقی‌مانده
$used_traffic_gb = round(($marzban_user['used_traffic'] ?? 0) / (1024**3), 2);
$total_traffic_gb = round(($marzban_user['data_limit'] ?? 0) / (1024**3), 2);
$expire_timestamp = $marzban_user['expire'] ?? 0;
$remaining_days = $expire_timestamp > 0 ? floor(($expire_timestamp - time()) / 86400) : 0;
if ($remaining_days < 0) $remaining_days = 0;

echo json_encode([
    'subscription_url' => $subscription_url,
    'configs' => $configs_result,
    'usage' => [
        'used_gb' => $used_traffic_gb,
        'total_gb' => $total_traffic_gb,
    ],
    'remaining_days' => $remaining_days
]);