</div> <script>
document.addEventListener('DOMContentLoaded', function() {
    const sidebar = document.getElementById('sidebar');
    const mainContent = document.getElementById('main-content');
    const sidebarToggle = document.getElementById('sidebar-toggle');

    // تابع برای کوچک/بزرگ کردن سایدبار
    const toggleSidebar = () => {
        if (sidebar.classList.contains('w-64')) {
            sidebar.classList.remove('w-64');
            sidebar.classList.add('w-20');
            mainContent.classList.remove('mr-64');
            mainContent.classList.add('mr-20');
            sidebar.querySelectorAll('nav span').forEach(el => el.classList.add('hidden'));
            sidebar.querySelectorAll('nav .submenu-toggle i.ri-arrow-down-s-line').forEach(el => el.classList.add('hidden'));
        } else {
            sidebar.classList.remove('w-20');
            sidebar.classList.add('w-64');
            mainContent.classList.remove('mr-20');
            mainContent.classList.add('mr-64');
            setTimeout(() => {
                sidebar.querySelectorAll('nav span').forEach(el => el.classList.remove('hidden'));
                sidebar.querySelectorAll('nav .submenu-toggle i.ri-arrow-down-s-line').forEach(el => el.classList.remove('hidden'));
            }, 150);
        }
    };
    
    if (sidebarToggle) {
        sidebarToggle.addEventListener('click', toggleSidebar);
    }

    // اسکریپت منوی کشویی کاربر (پروفایل)
    const userMenuBtn = document.getElementById('user-menu-btn');
    const userDropdown = document.getElementById('user-dropdown');
    if (userMenuBtn) {
        userMenuBtn.addEventListener('click', (e) => { e.stopPropagation(); userDropdown.classList.toggle('hidden'); });
    }
    document.addEventListener('click', (e) => {
        if (userDropdown && !userDropdown.classList.contains('hidden') && !userMenuBtn.contains(e.target)) {
            userDropdown.classList.add('hidden');
        }
    });

    // اسکریپت جدید برای باز و بسته شدن زیرمنوها
    document.querySelectorAll('.submenu-toggle').forEach(toggle => {
        toggle.addEventListener('click', function() {
            this.nextElementSibling.classList.toggle('open');
            this.querySelector('i.ri-arrow-down-s-line').classList.toggle('rotate-180');
        });
    });

    // اگر در یکی از صفحات زیرمنو بودیم، منوی اصلی را باز نگه دار
    if (document.querySelector('.sidebar-item.submenu-toggle.active')) {
        const activeToggle = document.querySelector('.sidebar-item.submenu-toggle.active');
        activeToggle.nextElementSibling.classList.add('open');
        activeToggle.querySelector('i.ri-arrow-down-s-line').classList.add('rotate-180');
    }
});
</script>
</body>
</html>