<?php 
include 'includes/header.php'; 

if (isset($_SESSION['flash_message'])) {
    $flash_message = '<div class="mb-6 p-4 rounded-lg ' . (($_SESSION['flash_message_type'] ?? 'success') === 'success' ? 'bg-green-100 text-green-800' : 'bg-red-100 text-red-800') . ' shadow">' . htmlspecialchars($_SESSION['flash_message']) . '</div>';
    unset($_SESSION['flash_message'], $_SESSION['flash_message_type']);
}

include 'includes/sidebar.php'; 

$user_id = $_SESSION['user_id'];
$stmt = $pdo->prepare(
    "SELECT o.*, p.name as plan_name 
     FROM orders o JOIN plans p ON o.plan_id = p.id
     WHERE o.user_id = ? ORDER BY o.order_date DESC"
);
$stmt->execute([$user_id]);
$services = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<style>
.glass-effect { background: rgba(255, 255, 255, 0.9); backdrop-filter: blur(10px); -webkit-backdrop-filter: blur(10px); }
.modal-enter { animation: modalFadeIn 0.3s ease-out forwards; }
@keyframes modalFadeIn { from { opacity: 0; transform: scale(0.95); } to { opacity: 1; transform: scale(1); } }
.progress-bar { transition: width 0.5s ease-in-out; }
</style>

<main id="main-content" class="flex-1 p-6 mr-64 transition-all duration-300">
    <div class="mb-8">
        <h1 class="text-2xl font-bold text-gray-800">سرویس های من</h1>
        <p class="text-gray-600 mt-1">لیست تمام سرویس‌های فعال و منقضی شده شما.</p>
    </div>

    <?php if (isset($flash_message)) { echo $flash_message; } ?>

    <?php if (empty($services)): ?>
        <div class="bg-blue-100 text-blue-800 p-6 rounded-lg text-center shadow">
            <h3 class="font-bold text-xl">شما سرویس فعالی ندارید!</h3>
            <a href="buy-service.php" class="mt-4 inline-block bg-primary text-white px-6 py-2 rounded-lg hover:bg-primary/90 transition-colors">خرید سرویس جدید</a>
        </div>
    <?php else: ?>
        <div class="grid grid-cols-1 md:grid-cols-2 xl:grid-cols-3 gap-6">
            <?php foreach($services as $service): ?>
                <div class="bg-white rounded-lg shadow-sm p-6 flex flex-col">
                    <h3 class="text-xl font-semibold text-gray-900 mb-4 pb-3 border-b"><?= htmlspecialchars($service['plan_name']) ?></h3>
                    <div class="space-y-3 text-gray-600 text-sm flex-grow">
                        <p class="flex justify-between"><strong>نام کاربری:</strong> <span class="font-mono text-gray-800"><?= htmlspecialchars($service['marzban_username']) ?></span></p>
                        <p class="flex justify-between"><strong>تاریخ انقضا:</strong> <span class="font-mono text-red-600 font-bold"><?= $service['expiry_date'] ? date("Y/m/d", strtotime($service['expiry_date'])) : 'نامحدود' ?></span></p>
                    </div>
                    <div class="mt-4 pt-4 border-t flex items-center gap-2">
                        <button class="details-btn flex-1 text-sm bg-indigo-100 text-indigo-600 px-3 py-2 rounded-lg hover:bg-indigo-200 transition-colors" data-username="<?= htmlspecialchars($service['marzban_username']) ?>">
                            <i class="ri-eye-line align-middle"></i> جزئیات و کانفیگ‌ها
                        </button>
                        <?php if($service['status'] !== 'terminated'): ?>
                            <a href="renew-service.php?order_id=<?= $service['id'] ?>" class="flex-1 text-center text-sm bg-green-100 text-green-700 px-3 py-2 rounded-lg hover:bg-green-200 transition-colors">
                                <i class="ri-refresh-line align-middle"></i> تمدید
                            </a>
                        <?php endif; ?>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
    <?php endif; ?>
</main>

<div id="service-modal" class="hidden fixed inset-0 bg-black bg-opacity-60 flex items-center justify-center p-4 z-50">
    </div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const modalContainer = document.getElementById('service-modal');

    document.querySelectorAll('.details-btn').forEach(button => {
        button.addEventListener('click', function() {
            const username = this.dataset.username;
            modalContainer.innerHTML = `<div class="text-white text-center text-lg">درحال بارگذاری اطلاعات زنده...</div>`;
            modalContainer.classList.remove('hidden');

            fetch(`get_service_details.php?username=${username}`)
                .then(response => response.json())
                .then(data => {
                    if (data.error) {
                        modalContainer.innerHTML = `<div class="bg-red-100 text-red-800 p-4 rounded-lg shadow-lg">${data.error}</div>`;
                        setTimeout(() => modalContainer.classList.add('hidden'), 3000);
                        return;
                    }

                    let configsHTML = '';
                    if(data.configs && data.configs.length > 0) {
                        data.configs.forEach(config => {
                            const name = decodeURIComponent(config.split('#')[1] || 'کانفیگ');
                            configsHTML += `
                                <div class="bg-white border border-gray-100 rounded-lg p-3 shadow-sm hover:shadow-md transition-shadow">
                                    <div class="flex justify-between items-center">
                                        <span class="font-medium text-gray-700 text-sm truncate ml-2">${name}</span>
                                        <button class="copy-button flex-shrink-0 !rounded-button flex items-center justify-center h-8 w-8 text-gray-500 hover:text-indigo-600 hover:bg-indigo-50 transition-colors" data-config="${config}">
                                            <i class="ri-file-copy-line"></i>
                                        </button>
                                    </div>
                                </div>`;
                        });
                    } else {
                        configsHTML = '<p class="text-center text-gray-500 text-sm">هیچ کانفیگ مجزایی یافت نشد.</p>';
                    }
                    
                    let usagePercentage = data.usage.total_gb > 0 ? (data.usage.used_gb / data.usage.total_gb) * 100 : 0;
                    
                    modalContainer.innerHTML = `
                        <div class="modal-enter glass-effect w-full max-w-2xl rounded-2xl shadow-lg overflow-hidden border border-gray-100">
                            <div class="relative p-4 border-b border-gray-100">
                                <button id="closeModal" class="absolute left-4 top-1/2 transform -translate-y-1/2 w-8 h-8 flex items-center justify-center text-gray-500 hover:text-gray-800 transition-colors rounded-full hover:bg-gray-100">
                                    <i class="ri-close-line ri-lg"></i>
                                </button>
                                <h2 class="text-xl font-bold text-gray-800 text-center">جزئیات سرویس</h2>
                            </div>
                            
                            <div class="p-4 bg-gray-50">
                                <div class="flex justify-between items-center text-sm font-medium text-gray-600 mb-1">
                                    <span>مصرف: ${data.usage.used_gb} GB</span>
                                    <span>حجم کل: ${data.usage.total_gb} GB</span>
                                </div>
                                <div class="w-full bg-gray-200 rounded-full h-2.5">
                                    <div class="bg-gradient-to-r from-green-400 to-blue-500 h-2.5 rounded-full progress-bar" style="width: ${usagePercentage}%"></div>
                                </div>
                                <div class="text-center text-sm font-bold text-gray-700 mt-2">
                                    ${data.remaining_days} روز باقی مانده
                                </div>
                            </div>

                            <div class="p-4">
                                <h3 class="text-lg font-semibold text-gray-800 mb-3">کانفیگ‌های مجزا</h3>
                                <div class="space-y-3 max-h-[40vh] overflow-y-auto pr-1">${configsHTML}</div>
                            </div>
                            <div class="p-4 bg-gray-50 flex justify-end">
                                <button id="copyAllConfigs" class="w-full sm:w-auto !rounded-button bg-indigo-500 text-white py-2 px-4 font-medium hover:bg-indigo-600 transition-colors text-sm">
                                    <i class="ri-file-copy-2-line ml-2"></i>کپی همه کانفیگ‌ها
                                </button>
                            </div>
                        </div>
                    `;
                })
                .catch(error => {
                    modalContainer.innerHTML = `<div class="bg-red-100 text-red-800 p-4 rounded-lg shadow-lg">خطای شبکه: ${error}</div>`;
                    setTimeout(() => modalContainer.classList.add('hidden'), 3000);
                });
        });
    });

    modalContainer.addEventListener('click', function(e) {
        if (e.target.id === 'closeModal' || e.target.closest('#closeModal')) {
            modalContainer.classList.add('hidden');
        }

        if (e.target.closest('.copy-button')) {
            const button = e.target.closest('.copy-button');
            navigator.clipboard.writeText(button.dataset.config).then(() => {
                button.innerHTML = `<i class="ri-check-line text-green-500"></i>`;
                setTimeout(() => { button.innerHTML = `<i class="ri-file-copy-line"></i>`; }, 2000);
            });
        }
        
        if (e.target.id === 'copyAllConfigs') {
            const allConfigs = Array.from(modalContainer.querySelectorAll('.copy-button')).map(btn => btn.dataset.config).join('\\n');
            if(allConfigs) {
                navigator.clipboard.writeText(allConfigs).then(() => {
                    const button = e.target;
                    const originalText = button.innerHTML;
                    button.innerHTML = `<i class="ri-check-line ml-2"></i> کپی شد`;
                    setTimeout(() => { button.innerHTML = originalText; }, 2000);
                });
            } else {
                alert('هیچ کانفیگی برای کپی وجود ندارد.');
            }
        }
    });
});
</script>

<?php include 'includes/footer.php'; ?>